.\"
.\" "$Id: cupsenable.man 5099 2006-02-13 02:46:10Z mike $"
.\"
.\"   cupsenable/cupsdisable man page for the Common UNIX Printing System
.\"   (CUPS).
.\"
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636 USA
.\"
.\"       Voice: (301) 373-9600
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH cupsenable 8 "Common UNIX Printing System" "12 February 2006" "Easy Software Products"
.SH NAME
cupsdisable, cupsenable \- stop/start printers and classes
.SH SYNOPSIS
.B cupsdisable
[ -E ] [-U
.I username
] [ -c ] [ -h
.I server[:port]
] [ -r
.I reason
] destination(s)
.br
.B cupsenable
[ -E ] [-U
.I username
] [ -c ] [ -h
.I server[:port]
] destination(s)
.SH DESCRIPTION
\fIcupsenable\fR starts the named printers or classes.
.LP
\fIcupsdisable\fR stops the named printers or classes.  The
following options may be used:
.TP 5
-E
.br
Forces encryption of the connection to the server.
.TP 5
-U username
.br
Uses the specified username when connecting to the server.
.TP 5
-c
.br
Cancels all jobs on the named destination.
.TP 5
-h server[:port]
.br
Uses the specified server and port.
.TP 5
-r "reason"
.br
Sets the message associated with the stopped state. If no reason is specified
then the message is set to "Reason Unknown".
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to
contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The System V versions of these commands are \fIdisable\fR and
\fIenable\fR. They have been renamed to avoid conflicts with the
\fIbash(1)\fR build-in command of the same name.
.LP
The CUPS versions of \fIdisable\fR and \fIenable\fR may ask the
user for an access password depending on the printing system
configuration.  This differs from the System V versions which
require the root user to execute these commands.
.SH SEE ALSO
\fIaccept(8)\fR, \fIcancel(1)\fR, \fIlp(1)\fR, \fIlpadmin(8)\fR,
\fIlpstat(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 1997-2006 by Easy Software Products, All Rights Reserved.

.\"
.\" End of "$Id: cupsenable.man 5099 2006-02-13 02:46:10Z mike $".
.\"
