#include <gtk/gtk.h>
#include "dw_container.h"

static void Dw_container_init          (DwContainer *container);
static void Dw_container_class_init    (DwContainerClass *klass);

static void Dw_container_destroy       (GtkObject *object);

enum
{
   ADD,
   REMOVE,
   LAST_SIGNAL
};

// static guint container_signals[LAST_SIGNAL] = { 0 };

static DwWidgetClass *parent_class;


/*
 * Standard Gtk+ function
 */
GType a_Dw_container_get_type (void)
{
   static GType type = 0;

   if (!type) {
      GTypeInfo info = {
         sizeof (DwContainerClass),
         (GBaseInitFunc) NULL,
         (GBaseFinalizeFunc) NULL,
         (GClassInitFunc) Dw_container_class_init,
         (GClassFinalizeFunc) NULL,
         (gconstpointer) NULL,
         sizeof (DwContainer),
         0,
         (GInstanceInitFunc) Dw_container_init,
         (GTypeValueTable *) NULL
      };
      GTypeFlags flags = 0;
      type = g_type_register_static(DW_TYPE_WIDGET, "DwContainer",
                                    &info, flags);
   }
   return type;
}


/*
 * Standard Gtk+ function
 */
static void Dw_container_init (DwContainer *container)
{
}


/*
 * Standard Gtk+ function
 */
static void Dw_container_class_init (DwContainerClass *klass)
{
   GtkObjectClass *object_class;

   parent_class = gtk_type_class (DW_TYPE_WIDGET);
   object_class = GTK_OBJECT_CLASS (klass);

#if 0
   container_signals[ADD] =
      gtk_signal_new ("add",
                      GTK_RUN_FIRST,
                      object_class->type,
                      GTK_SIGNAL_OFFSET (DwContainerClass, add),
                      gtk_marshal_NONE__POINTER,
                      GTK_TYPE_NONE, 1,
                      GTK_TYPE_WIDGET);
  container_signals[REMOVE] =
     gtk_signal_new ("remove",
                     GTK_RUN_FIRST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET (DwContainerClass, remove),
                     gtk_marshal_NONE__POINTER,
                     GTK_TYPE_NONE, 1,
                     GTK_TYPE_WIDGET);
#endif

   object_class->destroy = Dw_container_destroy;
}


/*
 * Standard Gtk+ function
 */
static void Dw_container_destroy (GtkObject *object)
{
   a_Dw_container_forall (DW_CONTAINER (object),
                          (DwCallback) gtk_object_destroy,
                          NULL);

   GTK_OBJECT_CLASS(parent_class)->destroy (object);
}



/*
 * Add a widget in a "standard" way.
 */
void a_Dw_container_add (DwContainer *container,
                         DwWidget *child)
{
   DwContainerClass *klass;

   klass = DW_CONTAINER_CLASS (G_OBJECT_GET_CLASS (G_OBJECT (container)));
   if (klass->add)
      (* (klass->add)) (container, child);
}


/*
 *
 */
void a_Dw_container_forall (DwContainer *container,
                            DwCallback   callback,
                            gpointer     callback_data)
{
   DwContainerClass *klass;
   
   klass = DW_CONTAINER_CLASS(G_OBJECT_GET_CLASS(G_OBJECT(container)));
   if (klass->forall)
      (* (klass->forall)) (container, callback, callback_data);

   /* The following code is handy for testing DwIterator: */
    
   /*
   DwIterator *it;

   if ((it = a_Dw_widget_iterator (DW_WIDGET (container),
                                   DW_CONTENT_WIDGET))) {
      while (a_Dw_iterator_next(it))
         callback (it->content.data.widget, callback_data);
      a_Dw_iterator_free (it);
   }
   */
}


/*
 * Used to search for text strings inside containers
 */
gint a_Dw_container_findtext (DwContainer *container,
                              gpointer FP, gpointer KP,
                              gchar *NewKey)
{
   DwContainerClass *klass;

   klass = DW_CONTAINER_CLASS (G_OBJECT_GET_CLASS (G_OBJECT (container)));
   if (klass->findtext)
      return (* (klass->findtext)) (container, FP, KP, NewKey);
   return 0;
}


/*****************************************************************************/

/* todo: a_ function? */
void Dw_container_remove (DwContainer *container,
                          DwWidget *child)
{
   DwContainerClass *klass;

   klass = DW_CONTAINER_CLASS (G_OBJECT_GET_CLASS (G_OBJECT (container)));
   if (klass->remove)
      (* (klass->remove)) (container, child);
}


