/*
 * gdict Dictionary for UNIX
 * Copyright (C) 2003 Alexander Zapjagaev <frustum@frustum.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

#include "main.h"
#include "menu.h"
#include "dict.h"
#include "transwindow.h"
#include "about.h"

typedef struct mainwindow_s mainwindow_t;

#include "dictwindow.h"

struct mainwindow_s {
	GtkWidget *window;			/*  */
	GtkWidget *scrolled_window;	/*  */
	GtkWidget *clist;			/*   */
	GtkWidget *entry;			/*   */
	
	int focus;					/*   entry  clist */
	
	char **dicts;				/*    */
	int num_dicts;				/*    */
	
	dict_t *root;				/*   */
	int num_words;				/*     */
	
	int index;					/*     */
};

enum {
	FOCUS_ENTRY,
	FOCUS_CLIST
};

mainwindow_t *main_window_create(void);
void main_window_dict_load(mainwindow_t *mainwin,char *name);
void main_window_dict_free(mainwindow_t *mainwin);
void main_window_clist_load(mainwindow_t *mainwin);
void main_window_clist_free(mainwindow_t *mainwin);

#endif /* __MAINWINDOW_H__ */
