#! /bin/sh
# Copyright(C) 2004, Intel Corporation, All Rights Reserved
# This script uninstalls Intel(R) Performance Libraries

READ_YES_NO ()
{
    DEFAULT_ANSWER=$1
    YES_ANSWER="y yes yea yeah yep ok"
    NO_ANSWER="n no not nop nope"
    while [ 1 -eq 1 ] ; do
	echo -n  " (Yes/No) [${DEFAULT_ANSWER}] : "
	read YESNO
	if [ "$YESNO" = "" ] ; then
	    YESNO=$DEFAULT_ANSWER
	fi
	YESNO="$(echo $YESNO | tr -s A-Z a-z)"
	for c in $YES_ANSWER ; do
	    if [ "$YESNO" = "$c" ] ; then
		YESNO="y"
		return 0
	    fi
	done
	for c in $NO_ANSWER ; do
	    if [ "$YESNO" = "$c" ] ; then
		YESNO="n"
		return 0
	    fi
	done
	echo -n "Please try again"
    done
}

GETCHOICE()
{
    MAX_INDEX=$#
    INDEX=0
    echo ; echo "The following products are installed."
    for INSTALLED_RPM in $@
    do
        INDEX=$(($INDEX+1))
	echo -n $INDEX.  
	rpm -qi $INSTALLED_RPM | grep Summary | cut -d: -f2
    done
    echo x.  Exit
    echo "Which would you like to uninstall?"
    read CHOSEN_INDEX &> /dev/null
    if [ $CHOSEN_INDEX = x ]&>/dev/null ; then
	echo Exiting...
	exit 0
    elif [ $CHOSEN_INDEX -ge 1 ] &> /dev/null && [ $CHOSEN_INDEX -le $MAX_INDEX ] &> /dev/null ; then
	CHOSEN_RPM=$(echo $INSTALLED_RPM_LIST | cut -d' ' -f"$CHOSEN_INDEX")
	CHOSEN_FULL_NAME=$(rpm -qi $CHOSEN_RPM | grep Summary | cut -d: -f2)
	UNINSTALLPRODUCT
    else
	if [ $MAX_INDEX -eq 1 ] ; then
	    echo "Sorry, try 1 or x."
	else 
	    echo "Sorry, try a number between 1 and $MAX_INDEX, or x."
	fi    
    fi
}

UNINSTALLPRODUCT ()
{
    DEFRPMCMD='-e'
    echo -n "With which rpm options do you want to uninstall$CHOSEN_FULL_NAME [$DEFRPMCMD]? : "
    read RPMCMD &> /dev/null
    if [ -z "$RPMCMD" ] &> /dev/null ; then
	RPMCMD=$DEFRPMCMD
    elif ! echo "$RPMCMD" | sed s@^\ *@@ | grep '^-' &> /dev/null ; then
	RPMCMD="-${RPMCMD}"
    fi	
    
    if [ "${CRYPTO}" != "" ] && [ "${CRYPTO}" != "$CHOSEN_RPM" ] ; then 
	#CHOSEN_RPM="${CRYPTO} ${CHOSEN_RPM}"
	CRYPTO_FULL_NAME=$(rpm -qi $CRYPTO | grep Summary | cut -d: -f2)
	echo -n "The $CRYPTO_FULL_NAME will be already uninstalled. Ok?"
	READ_YES_NO "Yes"
	if [ "$YESNO" = "y" ] ; then
	    echo -n "Uninstalling $CRYPTO_FULL_NAME..."
	    if rpm $RPMCMD $CRYPTO ; then
		echo "  Successful."
	    else
		echo "  Unsuccessful."
	    fi
	else
    	    exit 1
        fi
    fi
    echo -n "Uninstalling $CHOSEN_FULL_NAME..."
    if rpm $RPMCMD $CHOSEN_RPM ; then
	echo "  Successful."
    else
	echo "  Unsuccessful."
    fi
}

clear
# check if USER is root
if [ "$USER" != "root" ] ; then
    if [ ! -w /dev ] ; then
        echo -n "NOTE:  Super-user or \"root\" privileges are required "
        echo "in order to continue."
        echo -n "Please enter \"root\" "
        exec su -c "/bin/sh $0"
        echo ""
        exit 0
    fi
fi

RPM_LIST=$(echo $(rpm -qf $0 | sort -r) )
CHOSEN_RPM=$(echo $RPM_LIST | cut -d' ' -f1)
IS_INSTALLED=$(echo $CHOSEN_RPM | grep intel)
if [ "$IS_INSTALLED" = "" ]; then 
    echo "Nothing to uninstall. Press Enter to exit..."
    read
    exit 1
fi

CHOSEN_FULL_NAME=$(rpm -qi $CHOSEN_RPM | grep Summary | cut -d: -f2)
CRYPTO=$(echo "$RPM_LIST " | cut -d' ' -f2)
if [ "${CRYPTO}" != "" ]; then 
    INSTALLED_RPM_LIST="$CHOSEN_RPM $CRYPTO"
    GETCHOICE $INSTALLED_RPM_LIST
else
    echo -n "Do you really want to uninstall $CHOSEN_FULL_NAME?"
    READ_YES_NO "Yes"
    if [ "$YESNO" = "y" ] ; then
        UNINSTALLPRODUCT $RPM_NAME
    else
        exit 1
    fi
fi
