/* This file is part of the KDE project
   Copyright (c) 2004 Kevin Ottens <ervin ipsquad net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef SYSTEMMENU_H
#define SYSTEMMENU_H

#include <kpanelmenu.h>
#include <kurl.h>
#include <kdirlister.h>
#include <kfileitem.h>

class SystemMenu : public KPanelMenu
{
    Q_OBJECT

    public:
        SystemMenu(QWidget *parent, const char *name,
                   const QStringList & /*args*/);
        ~SystemMenu();

    protected slots:
        void initialize();
        void slotExec(int id);

        void slotCompleted();

    private:
        void append(const QString &icon, const KURL &url, const QString &label);
        KDirLister m_dirLister;
        KFileItemList m_entries;
        QMap<int, KURL> m_urlMap;
};

#endif
