/*
    This file is part of libkabc.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

/*
Enhanced Version of the file for platform independent KDE tools.
Copyright (c) 2004 Ulf Schenk

$Id: phonenumber.cpp,v 1.5 2004/09/09 18:57:58 ulf69 Exp $
*/

#include <kapplication.h>
#include <klocale.h>

#include "phonenumber.h"

using namespace KABC;

PhoneNumber::PhoneNumber() :
  mType( Home )
{
  init();
}

PhoneNumber::PhoneNumber( const QString &number, int type ) :
  mType( type ), mNumber( number )
{
  init();
}

PhoneNumber::~PhoneNumber()
{
}

void PhoneNumber::init()
{
  mId = KApplication::randomString( 8 );
}

bool PhoneNumber::operator==( const PhoneNumber &p ) const
{
  if ( mNumber != p.mNumber ) return false;
  if ( mType != p.mType ) return false;
  
  return true;
}

bool PhoneNumber::operator!=( const PhoneNumber &p ) const
{
  return !( p == *this );
}

void PhoneNumber::setId( const QString &id )
{
  mId = id;
}

QString PhoneNumber::id() const
{
  return mId;
}

void PhoneNumber::setNumber( const QString &number )
{
  mNumber = number;
}

QString PhoneNumber::number() const
{
  return mNumber;
}

void PhoneNumber::setType( int type )
{
  mType = type;
}

int PhoneNumber::type() const
{
  return mType;
}

QString PhoneNumber::typeLabel() const
{
  QString label;
  bool first = true;

  TypeList list = typeList();

  TypeList::Iterator it;
  for ( it = list.begin(); it != list.end(); ++it ) {
    if ( ( type() & (*it) ) && ( (*it) != Pref ) ) {
      label.append( ( first ? "" : "/" ) + typeLabel( *it ) );
      if ( first )
        first = false;
    }
  }

  return label;
}

QString PhoneNumber::label() const
{
  return typeLabel( type() );
}

PhoneNumber::TypeList PhoneNumber::typeList()
{
  TypeList list;
  
  list << Home << Work << Msg << Pref << Voice << Fax << Cell << Video
       << Bbs << Modem << Car << Isdn << Pcs << Pager << Sip;

  return list;
}

QString PhoneNumber::label( int type )
{
  return typeLabel( type );
}

QString PhoneNumber::typeLabel( int type )
{
  QString typeString;
  
  if ((type & Home) == Home)
    typeString += i18n("Home");
  else if ((type & Work) == Work)
    typeString += i18n("Work");
   
  if (!typeString.isEmpty())
    typeString += " ";
      
  if ((type & Cell) == Cell)
    typeString += i18n("Mobile");
  else if ((type & Fax) == Fax)
    typeString += i18n("Fax");
  else if ((type & Msg) == Msg)
    typeString += i18n("Messenger");
  else if ((type & Voice) == Voice) {
// add nothing in case of the Voice flag
//    typeString += i18n("Voice");
  }
  else if ((type & Video) == Video)
    typeString += i18n("Video");
  else if ((type & Bbs) == Bbs)
    typeString += i18n("Mailbox");
  else if ((type & Modem) == Modem)
    typeString += i18n("Modem");
  else if ((type & Car) == Car)
    typeString += i18n("Car");
  else if ((type & Isdn) == Isdn)
    typeString += i18n("ISDN");
  else if ((type & Pcs) == Pcs)
    typeString += i18n("PCS");
  else if ((type & Pager) == Pager)
    typeString += i18n("Pager");
  else if ((type & Sip) == Sip)
    typeString += i18n("SIP");
    
  // add the prefered flag    
  if (!typeString.isEmpty())
    typeString += " ";

  if ((type & Pref) == Pref)
    typeString += i18n("(p)");

  //if we still have no match, return "other"        
  if (typeString.isEmpty())
    return i18n("Other");
    
    
  return typeString;
}

QDataStream &KABC::operator<<( QDataStream &s, const PhoneNumber &phone )
{
    return s << phone.mId << phone.mType << phone.mNumber;
}

QDataStream &KABC::operator>>( QDataStream &s, PhoneNumber &phone )
{
    s >> phone.mId >> phone.mType >> phone.mNumber;

    return s;
}
