/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kaboutdata_h__
#define __kaboutdata_h__

#include <qcstring.h>

// ###

class KAboutData
{
public:
    enum { License_LGPL };

    KAboutData( const char *appname, const char */*progname*/, const char */*version*/,
                const char * /*description*/ = 0, int /*license*/ = 0 )
        { m_appname = appname; }

    void addAuthor( const char */*name*/,
                    const char */*task*/,
                    const char */*email*/ )
        {}

    QCString appName() const { return m_appname; }

private:
    QCString m_appname;
};

#endif
