/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/


#include "kfiledialog.h"

#include <qlayout.h>
#include <qconfig.h>

#if defined(QT_NO_FILEDIALOG)
QString 
KFileDialog::getOpenFileName(const QString &, const QString &, QWidget *, const QString &) 
{
    return QString::null; // sorry bud :)
}
#else
QString KFileDialog::getOpenFileName( const QString &dir,
                                      const QString &filter,
                                      QWidget *parent, const QString &caption )
{
#if defined(_QT_QPE_)
    QPEFileSelectorWrapper *qpefd = new QPEFileSelectorWrapper( parent );
    qpefd->setCaption( caption );
    qpefd->showMaximized();

    QString result;

    if ( qpefd->exec() == QDialog::Accepted )
        result = qpefd->selectedPath(); 

    delete qpefd;

    return result;
#else
    return QFileDialog::getOpenFileName( dir, filter, parent, 0, caption );
#endif
}
#endif //QT_NO_FILEDIALOG

#if defined(ENABLE_READWRITE)

#if defined(QT_NO_FILEDIALOG)
QString 
KFileDialog::getSaveFileName(const QString &, const QString &, QWidget *, const QString &)
{
    return QString::null; // sorry bud :)
}
#else
QString KFileDialog::getSaveFileName( const QString &dir,
                                      const QString &filter,
                                      QWidget *parent, const QString &caption )
{
#if defined(_QT_QPE_)
    QPEFileSelectorWrapper *qpefd = new QPEFileSelectorWrapper( parent );
    qpefd->setCaption( caption );
    qpefd->showMaximized();

    QString result;

    if ( qpefd->exec() == QDialog::Accepted )
        result = qpefd->selectedPath(); 

    delete qpefd;

    return result;
#else
    return QFileDialog::getSaveFileName( dir, filter, parent, 0, caption );
#endif
}
#endif // QT_NO_FILEDIALOG
#endif // ENABLE_READWRITE

#if defined(_QT_QPE_) || defined(Q_WS_WIN32)

QPEFileSelectorWrapper::QPEFileSelectorWrapper( QWidget *parent, const char *name )
    : QDialog( parent, name, true )
{
#if defined(_QT_QPE_)
    QVBoxLayout *layout = new QVBoxLayout( this );

    FileSelector *fs = new FileSelector( QString::null, this, "fs" );
    layout->addWidget( fs );

    fs->setNewVisible( false );

    connect( fs, SIGNAL( fileSelected( const DocLnk & ) ),
             this, SLOT( fileSelected( const DocLnk & ) ) );
    connect( fs, SIGNAL( closeMe() ),
             this, SLOT( accept() ) );
#endif
}

QPEFileSelectorWrapper::~QPEFileSelectorWrapper()
{
}

void QPEFileSelectorWrapper::fileSelected( const DocLnk &doc )
{
    m_path = doc.file();
}

#include "kfiledialog.moc"
#endif
