#ifndef __kmimetype_h__
#define __kmimetype_h__

#include <ksharedptr.h>
#include <kurl.h>
#include <kicontheme.h>
#include <qvaluelist.h>
#include <qpixmap.h>

#include <sys/types.h>

class KMimeType : public KShared
{
public:
    KMimeType( const QString &name = QString::null ) : m_name( name ) {}

    typedef KSharedPtr<KMimeType> Ptr;
    typedef QValueList<Ptr> List;

    bool is( const QString& mimeTypeName ) const {
        return mimeTypeName == m_name;
    }

    static Ptr findByURL( const KURL & /* ### */ )
        { return new KMimeType( defaultMimeType() ); }

    QString name() const { return m_name; }

    static QString comment( ) { return QString::null; }

    static QString comment( const KURL &, bool ) { return QString::null; }

    static QPixmap pixmapForURL( const KURL &, mode_t, KIcon::Group, int) 
        { return QPixmap(); }

    static Ptr mimeType( const QString& ) { return new KMimeType; }

    QPixmap pixmap( int ) { return QPixmap(); }

    static const QString &defaultMimeType();

private:
    QString m_name;
};

#endif
