/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2002 Paul Chitescu <Paul.Chitescu@IMC-Group.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kstdaction_h__
#define __kstdaction_h__

class QObject;
class QString;
class KAction;
class KToggleAction;

// Needed by kdelibs 3.1
class KActionCollection;

class KStdAction
{
public:
    enum StdAction {
	New=1, Open, Save, SaveAs, Close, Print, Quit,
	Undo, Redo, Cut, Copy, Paste, SelectAll, Find, FindNext, FindPrevious,
	Zoom, Redisplay,
	Back, Forward, Home,
	AddBookmark, EditBookmarks,
	Spelling,
	ShowToolbar, ShowStatusbar,
	Preferences,
	Help,
	_std_last
    };

    static KAction *action( StdAction act_enum, const QObject *recvr = 0,
                	    const char *slot = 0, QObject *parent = 0,
                	    const char *name = 0L );

    static const char* stdName( StdAction act_enum );

    static QString stdText( int act_enum );
    static bool stdToggle( int act_enum );
    static int stdAccel( int act_enum );
    static int stdAction( const char *name );

#define MKACTION(fname,ename) \
    static KAction *fname( const QObject *receiver = 0, const char *slot = 0, \
                           QObject *parent = 0, const char *name = 0 ) \
	{ return action( ename, receiver, slot, parent, name ); }

#define MKTOGGLEACTION(fname,ename) \
    static KToggleAction *fname( const QObject *receiver = 0, const char *slot = 0, \
                           QObject *parent = 0, const char *name = 0 ) \
	{ return (KToggleAction*)action( ename, receiver, slot, parent, name ); }

    MKACTION(openNew,New)
    MKACTION(open,Open)
    MKACTION(save,Save)
    MKACTION(saveAs,SaveAs)
    MKACTION(close,Close)
    MKACTION(print,Print)
    MKACTION(quit,Quit)
    MKACTION(undo,Undo)
    MKACTION(redo,Redo)
    MKACTION(cut,Cut)
    MKACTION(copy,Copy)
    MKACTION(paste,Paste)
    MKACTION(selectAll,SelectAll)
    MKACTION(find,Find)
    MKACTION(findNext,FindNext)
    MKACTION(findPrev,FindPrevious)
    MKACTION(zoom,Zoom)
    MKACTION(redisplay,Redisplay)
    MKACTION(back,Back)
    MKACTION(forward,Forward)
    MKACTION(home,Home)
    MKACTION(addBookmark,AddBookmark)
    MKACTION(editBookmarks,EditBookmarks)
    MKACTION(spelling,Spelling)
    MKTOGGLEACTION(showToolbar,ShowToolbar)
    MKTOGGLEACTION(showStatusbar,ShowStatusbar)
    MKACTION(preferences,Preferences)
    MKACTION(help,Help)

#undef MKACTION
#undef MKTOGGLEACTION
};

#endif
