#include <qwidget.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qpe/pim/contact.h>
#include <select_addressee_base.h>
#include "qtopiaaddressbookplugin.h"
#include "qtopiaaddressee.h"

QtopiaAddressBookPlugin::QtopiaAddressBookPlugin() : ref(0) {
  qDebug("QtopiaAddressBookPlugin::QtopiaAddressBookPlugin");
  access = new AddressBookAccess();
}

QtopiaAddressBookPlugin::~QtopiaAddressBookPlugin() {
  qDebug("QtopiaAddressBookPlugin::~QtopiaAddressBookPlugin");
  delete &access;
}

KABC::Addressee::List QtopiaAddressBookPlugin::getAddressees() {
  
  qDebug("Start: QtopiaAddressBookPlugin::getAddressees");

  AddressBookIterator it(*access);
  const PimContact *contact;
  KABC::Addressee::List result;

  for (contact=it.toFirst(); it.current(); ++it) {
    contact = it.current();
    result.append(QtopiaAddressee(*contact)); 
  }
  
  qDebug("End: QtopiaAddressBookPlugin::getAddressees");
  
  return result;
}

QString QtopiaAddressBookPlugin::name() {
  return "Qtopia addressbook plugin";
}

QRESULT QtopiaAddressBookPlugin::queryInterface( const QUuid &uuid, QUnknownInterface **iface )
{
    *iface = 0;
    if ( uuid == IID_QUnknown )
      *iface = this;
    else if ( uuid == IID_KOAddressBookInterface )
      *iface = this;
    if ( *iface )
      (*iface)->addRef();
    return QS_OK;
}

Q_EXPORT_INTERFACE()
{
    Q_CREATE_INSTANCE( QtopiaAddressBookPlugin )
}

