/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002
*/

#ifndef H3600_ASIC_IO_H
#define H3600_ASIC_IO_H

#include <asm/arch-sa1100/h3600_asic.h>
#include <linux/h3600_ts.h>

#include "../mach-ipaq/asic2_io.h"

struct pt_regs;

void h3600_asic_sleeve_isr(int irq, void *dev_id, struct pt_regs *regs);

int h3600_asic_audio_clock( long samplerate );
int h3600_asic_audio_power( long samplerate );
int h3600_asic_audio_mute( int mute );
int h3600_asic_backlight_control( enum flite_pwr power, unsigned char level );
int ipaq_mtd_asset_read( struct h3600_asset *asset );

/* LED control */
void h3600_asic_set_led( enum led_color color, int tbs, int pts, int dts );
int h3600_asic_notify_led( unsigned char mode, unsigned char duration, 
			   unsigned char ontime, unsigned char offtime );

#define h3600_asic_led_on(color)  \
        h3600_asic_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS, 4, 4 )

#define h3600_asic_led_off(color)  \
        h3600_asic_set_led(color, 0, 0, 0)

#define h3600_asic_led_blink(color,rate,pts,dts)  \
        h3600_asic_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS | rate, pts, dts )


int  h3600_asic_backlight_init(void);   
void h3600_asic_backlight_cleanup(void);

int  h3600_asic_audio_init(void); 
void h3600_asic_audio_cleanup(void);
int  h3600_asic_audio_suspend(void); 
void h3600_asic_audio_resume  (void);

int  ipaq_mtd_asset_init(void);   
void ipaq_mtd_asset_cleanup(void);

int  h3600_asic_bluetooth_init(void);
void h3600_asic_bluetooth_cleanup(void);
int  h3600_asic_bluetooth_suspend(void);
void h3600_asic_bluetooth_resume(void);



#endif /* H3600_ASIC_IO_H */
