/*
 * Copyright (c) SAMSUNG ELECTRONICS 
 * 	SW.LEE <hitchcar@sec.samsung.com>
 *      S3C2410 SD Register Field definitons 
 */

#ifndef _S3C2410_SDI_H
#define _S3C2410_SDI_H

#define rSDICON     (*(volatile unsigned *)(lowlevel->sd_base+0x00)) //SDI control
#define rSDIPRE     (*(volatile unsigned *)(lowlevel->sd_base+0x04)) //SDI baud rate prescaler
#define rSDICARG    (*(volatile unsigned *)(lowlevel->sd_base+0x08)) //SDI command argument
#define rSDICCON    (*(volatile unsigned *)(lowlevel->sd_base+0x0c)) //SDI command control
#define rSDICSTA    (*(volatile unsigned *)(lowlevel->sd_base+0x10)) //SDI command status
#define rSDIRSP0    (*(volatile unsigned *)(lowlevel->sd_base+0x14)) //SDI response 0
#define rSDIRSP1    (*(volatile unsigned *)(lowlevel->sd_base+0x18)) //SDI response 1
#define rSDIRSP2    (*(volatile unsigned *)(lowlevel->sd_base+0x1c)) //SDI response 2
#define rSDIRSP3    (*(volatile unsigned *)(lowlevel->sd_base+0x20)) //SDI response 3
#define rSDIDTIMER  (*(volatile unsigned *)(lowlevel->sd_base+0x24)) //SDI data/busy timer
#define rSDIBSIZE   (*(volatile unsigned *)(lowlevel->sd_base+0x28)) //SDI block size
#define rSDIDCON    (*(volatile unsigned *)(lowlevel->sd_base+0x2c)) //SDI data control
#define rSDIDCNT    (*(volatile unsigned *)(lowlevel->sd_base+0x30)) //SDI data remain counter
#define rSDIDSTA    (*(volatile unsigned *)(lowlevel->sd_base+0x34)) //SDI data status
#define rSDIFSTA    (*(volatile unsigned *)(lowlevel->sd_base+0x38)) //SDI FIFO status
#define rSDIIMSK    (*(volatile unsigned *)(lowlevel->sd_base+0x40)) //SDI interrupt mask

#ifdef __BIG_ENDIAN
#define rSDIDAT    (*(volatile unsigned *)(lowlevel->sd_base+0x3f)) //SDI data
			    //#define SDIDAT     (lowlevel->sd_base+0x3f)
#else  // Little Endian
#define rSDIDAT    (*(volatile unsigned *)(lowlevel->sd_base+0x3c)) //SDI data
#endif

/* Clock definitions */
#ifndef PCLK
#define  FCLK 202800000
#define  HCLK (FCLK/2)
#define  PCLK (HCLK/2)
#endif


/* SDI Control REgister */
#define BYTE_ORDER_TYPE_B         0x00000010
#define RECV_SDIO_INT_EN          0x00000008
#define READ_WAIT_EN              0x00000004
#define FIFO_RESET                0x00000002
#define CLOCK_OUT_EN              0x00000001


/* SDI Command Control Regiter Fields */
#define NORMAL_COMMAND            0x0000
#define ABORT_COMMAND             0x1000
#define CMD_WITH_DATA             0x0800
#define LONG_136RESPONSE          0x0400
#define WAIT_RESPONSE             0x0200
#define CMD_START                 0x0100
#define CMD_INDEX_MASK            0xff
#define START_TRANSMISSION_PRE    0x40


/* SDI Status Register Index */
#define SDI_CMD  0
#define SDI_DATA 1
#define SDI_FIFO 2
#define SDI_STATUS_LENGTH 3

/* SDI Command Status Register */
#define MMC_STATUS_CRC_RESPONSE_ERROR  (1<<12)
#define MMC_STATUS_CMD_SENT_DONE       (1<<11)
#define MMC_STATUS_RESPONSE_TIMEOUT    (1<<10)
#define MMC_STATUS_RESPONSE_RECV_DONE  (1<<9)
#define MMC_STATUS_TRANS_ON            (1<<8)
#define MMC_STATUS_RESPONSE_INDEX      (1<<7)
#define MMC_STATUS_RESPONSE_INDEX_MASK (0xff)
#define MMC_CMD_STATUS_WRITEONE_CLEAR  (0xf<<9)

/* SDI Data Status Register */
#define MMC_STATUS_RD_WAIT             (1<<10)
#define MMC_STATUS_IO_INT_DETECT       (1<<9)
#define MMC_STATUS_FIFO_ERROR          (1<<8)
#define MMC_STATUS_CRC_WRITE_ERROR     (1<<7)
#define MMC_STATUS_CRC_READ_ERROR      (1<<6)
#define MMC_STATUS_DATA_BUSY_TIMEOUT   (1<<5)
#define MMC_STATUS_DATA_TRANSFER_DONE  (1<<4)
#define MMC_STATUS_BUSY_FINISH         (1<<3)
#define MMC_STATUS_STARTBIT_ERROR      (1<<2)
#define MMC_STATUS_TX_DATA_ON_PROGRESS (1<<1)
#define MMC_STATUS_RX_DATA_ON_PROGRESS (1<<0)
#define MMC_DATA_STATUS_WRITEONE_CLEAR (0x1f<<2)

/* SDI FIFO Staus Register */
#define MMC_STATUS_FIFO_READY_FOR_TX   (1<<13)
#define MMC_STATUS_FIFO_READY_FOR_RX   (1<<12)
#define MMC_STATUS_FIFO_TX_HALF_FULL   (1<<11)
#define MMC_STATUS_FIFO_EMPTY          (1<<10)
#define MMC_STATUS_FIFO_RX_LAST_DATA   (1<<9 )
#define MMC_STATUS_FIFO_RX_FULL        (1<<8 )
#define MMC_STATUS_FIFO_RX_HALF_FULL   (1<<7)
#define MMC_STATUS_FIFO_COUNT_MASK     (0x7f)
#define MMC_FIFO_STATUS_WRITEONE_CLEAR (0x7f<<6) 
#define S3C_SD_FIFO_SIZE               ( 64)  /* Physical size =64 bytes */

/* SDI Block Size  SDIBSIZE register */
#define BLOCK_SIZE_ZERO 	  0x0

/* SDI Data Control Register -- SDIDCON */
#define INT_PERIOD_SINGLEBLOCK    0x00200000
#define TRAS_AF_RESPONSE_NODIRECT 0x00100000
#define RECV_AF_CMD_NODIRECT      0x00080000
#define BUSY_AF_CMD_NODIRECT      0x00040000
#define DATA_TRANS_BLOCK          0x00020000
#define STANDARD_BUS_MODE         0x00000000
#define WIDE_BUS_MODE_EN          0x00010000
#define DMA_MODE_EN               0x00008000
#define STOP_BY_FORCE             0x00004000
#define DATA_TRANS_READY          0x00000000
#define DATA_TRANS_MASK           0x00003000
#define DATA_TRANS_BUSY_START     0x00001000
#define DATA_RECV_START           0x00002000
#define DATA_TRANS_START          0x00003000
#define DATA_MAX_BLKNUM           0x00000fff
#define SDIDCON_ZERO              0x00000000


/* SDI Response Register 0  */
/* Card Status [31:0] (short), card Status[127:96](long) */
/* SDI Respnose Register 1 */
#define MMC_RESPONSE_CRC_8_0      (0xff<<24)
#define MMC_RESPONSE_LONG_127_96  (0xffffffff)
#define MMC_RESPONSE_LONG_135_128_VAL (0x3f)

#define SDIRSP1_CRC_SHIFT          24
#define MMC_RESPONSE_LONG_95_88   (0xff<<24)

/* SDI Response Register 2 */
#define MMC_RESPONSE_LONG_87_64   (0xffffff)
/* SDI Response Register 3 */
#define MMC_RESPONSE_LONG_63_32   (0xffffffff)
/* SDI Response Register 4 */
#define MMC_RESPONSE_LONG_31_0    (0xffffffff)

/* SDI Data / Busy Timer (SDIDTIMER) Register */
#define SDIDTIMER_DEFAULT         0xffff 

/* 
 * SDI Interrupt Mask Register 
 */
#define S3C_RESPONSE_CRC_INT_ON           0x20000
#define S3C_CMD_SENT_INT_ON               0x10000

#define S3C_CMD_RESPONSE_TIMEOUT_INT_ON   0x08000
#define S3C_RESPONSE_RECV_INT_ON          0x04000
#define S3C_RD_WAIT_REQUEST_INT_ON        0x02000
#define S3C_SDIO_RECV_INT_ON              0x01000

#define S3C_FIFO_FAIL_ERROR_INT_ON        0x00800
#define S3C_CRC_STATUS_ERROR_INT_ON       0x00400
#define S3C_DATA_CRC_FAIL_INT_ON          0x00200
#define S3C_DATA_TIMEOUT_INT_ON           0x00100

#define S3C_DATA_CNT_ZERO_INT_ON          0x00080
#define S3C_BUSY_COMPLETE_INT_ON          0x00040
#define S3C_START_BIT_ERROR_INT_ON        0x00020
#define S3C_TX_FIFO_HALF_INT_ON           0x00010

#define S3C_TX_FIFO_EMPTY_INT_ON          0x00008
#define S3C_RX_FIFO_LAST_DATA_INT_ON      0x00004
#define S3C_RX_FIFO_FULL_INT_ON           0x00002
#define S3C_RX_FIFO_HALF_INT_ON           0x00001
#define S3C_ALL_MMC_INT_MASK              0x00000

/*  COMMAND FORMAT DEFINITION */
#define START_DIRECTION            0x40
#define COMMAND_INDEX_MASK         0x3f



/* this Constant not used */

#define  MMC_CMD_DATA_CONT_FORMAT_NO_RESPONSE 0
#define  MMC_CMD_DATA_CONT_FORMAT_R1          2
#define  MMC_CMD_DATA_CONT_BUSY_BIT           4 
#define  MMC_CMD_DATA_CONT_FORMAT_R2          16 
#define  MMC_CMD_DATA_CONT_FORMAT_R3          32                    
#define  MMC_CMD_DATA_CONT_FORMAT_R4          64                    
#define  MMC_CMD_DATA_CONT_FORMAT_R5          128                 
#define  MMC_CMD_DATA_CONT_FORMAT_R6          256



#endif  /* _S3C2410_SDI_H */

