/*
 *  linux/drivers/char/spitz_rawmap_rollover.h
 *
 *  Copyright (C) 2004 Lineo Solutions, Inc.
 *
 * Based on:
 *  linux/drivers/char/tosa_rawmap_rollover.h
 *  linux/drivers/char/corgi_rawmap.h
 *  linux/drivers/char/poodle_rawmap.h
 *  linux/drivers/char/collie_rawmap1.h
 *
 * KeyCode definition table for COLLIE (SHARP)
 *
 * Copyright (C) 2001  SHARP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Change Log
 * 2002/9/2	SHARP	Support Corgi
 */

#ifndef __SPITZ_RAWMAP_ROLLOVER_H__
#define __SPITZ_RAWMAP_ROLLOVER_H__

#define ROLLOVER_NO_FLAG	0x00
#define ROLLOVER_TAB		0x01
#define ROLLOVER_DIRECT_ON	0x02
#define ROLLOVER_HORIZONTAL	0x04
#define ROLLOVER_VERTICAL	0x08
#define ROLLOVER_ENTQUESPC	0x10
#define ROLLOVER_LSHIFT		0x20
#define ROLLOVER_RSHIFT		0x40
#define ROLLOVER_FUNCTION	0x80

#define ROLLOVER_CHECK_FLAG(a, b)	(((a) & (b)) != 0)

static unsigned int rollover_flag_table[(NR_KEYCODES+1)] = {
	ROLLOVER_NO_FLAG,
	/*0*/	ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*1*/	ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*2*/	ROLLOVER_TAB, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*3*/	ROLLOVER_DIRECT_ON, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_RSHIFT/**/, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*4*/	ROLLOVER_DIRECT_ON, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_ENTQUESPC, ROLLOVER_NO_FLAG, ROLLOVER_ENTQUESPC, ROLLOVER_NO_FLAG, ROLLOVER_LSHIFT/**/, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	  /*5*/	ROLLOVER_DIRECT_ON, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_ENTQUESPC, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_VERTICAL, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_FUNCTION/**/, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*6*/	ROLLOVER_DIRECT_ON, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_HORIZONTAL, ROLLOVER_VERTICAL, ROLLOVER_HORIZONTAL, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG,
	/*7*/	ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG, ROLLOVER_NO_FLAG
};
#endif // end __SPITZ_RAWMAP_ROLLOVER_H__
