#ifndef _ASM_ARCHDM310_GIO_H
#define _ASM_ARCHDM310_GIO_H

#include <asm/hardware.h>

extern __inline__ void gio_dir_out(int num)
{
	if (num < 16)
		outw(inw(DM310_GIO_DIR0) & ~(1<<num), DM310_GIO_DIR0);
	else
		outw(inw(DM310_GIO_DIR1) & ~(1<<(num-16)), DM310_GIO_DIR1);
} 

extern __inline__ void gio_dir_in(int num)
{
	if (num < 16)
		outw(inw(DM310_GIO_DIR0) | (1<<num), DM310_GIO_DIR0);
	else
		outw(inw(DM310_GIO_DIR1) | (1<<(num-16)), DM310_GIO_DIR1);
}

extern __inline__ int gio_get(int num)
{
	if (num < 16)
		return ((inw(DM310_GIO_BITSET0) & (1<<num)) != 0);
	else
		return ((inw(DM310_GIO_BITSET1) & (1<<(num-16))) != 0);
}

extern __inline__ void gio_norm(int num)
{
	if (num < 16)
		outw(inw(DM310_GIO_INV0) & ~(1<<num), DM310_GIO_INV0);
	else
		outw(inw(DM310_GIO_INV1) & ~(1<<(num-16)), DM310_GIO_INV1);
}

extern __inline__ void gio_inv(int num)
{
	if (num < 16)
		outw(inw(DM310_GIO_INV0) | (1<<num), DM310_GIO_INV0);
	else
		outw(inw(DM310_GIO_INV1) | (1<<(num-16)), DM310_GIO_INV1);
}

extern __inline__ void gio_intr(int num)
{
	if (num < 16)
		outw(inw(DM310_GIO_IRQPORT) | (1<<num), DM310_GIO_IRQPORT);
}

extern __inline__ void gio_clear(int num)
{
	if (num < 16)
		outw(1<<num, DM310_GIO_BITCLR0);
	else
		outw(1<<(num-16), DM310_GIO_BITCLR1);
}

extern __inline__ void gio_set(int num)
{
	if (num < 16)
		outw(1<<num, DM310_GIO_BITSET0);
	else
		outw(1<<(num-16), DM310_GIO_BITSET1);
}

extern __inline__ void gio_write_gio0(u16 data, u16 mask)
{
	u16 set = data & mask;
	u16 clr = (~data) & mask; 

	if (set)
		outw(set, DM310_GIO_BITSET0);
	if (clr)
		outw(clr, DM310_GIO_BITCLR0);
}

extern __inline__ void gio_write_gio1(u16 data, u16 mask)
{
	u16 set = data & mask;
	u16 clr = (~data) & mask; 

	if (set)
		outw(set, DM310_GIO_BITSET1);
	if (clr)
		outw(clr, DM310_GIO_BITCLR1);
}

extern __inline__ u16 gio_read_gio0( void )
{
	return inw( DM310_GIO_BITSET0 );
}

extern __inline__ u16 gio_read_gio1( void )
{
	return inw( DM310_GIO_BITSET1 );
}

/* generic register write with mask */
#if 1
extern __inline__ void reg_write(u32 reg, u16 data, u16 mask)
{
	u16 val;
	 
	val = inw(reg);
	val &= ~mask;
	val |= (data & mask);
	
	outw(val, reg);
}
#else
#define reg_write(reg, data, mask)	\
do {					\
	u16 val;			\
	val = inw(reg);			\
	val &= (u16)~mask;		\
	val |= (u16)data & (u16)mask;	\
	outw(val, reg);			\
} while(0)
#endif

#endif
