#ifndef RSACIPHER_H
#define RSACIPHER_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <openssl/err.h>
#include <openssl/x509.h>
#include <openssl/x509v3.h>
#include <openssl/pem.h>
#include <openssl/pkcs12.h>
#include <openssl/ui.h>
#include <openssl/safestack.h>
#include "apps.h"

// using namespace std;

typedef class InitSSL {
	public:
		InitSSL() {
			if(!bio_err) bio_err = BIO_new_fp(stderr, BIO_NOCLOSE);
			ERR_load_crypto_strings();
			OpenSSL_add_all_ciphers();
			OpenSSL_add_all_digests();
		};

};

typedef class rsa_cipher {	
		char *private_key;
		char *public_key;
		int pad;

		EVP_PKEY *pkey;
		RSA *rsa;
		BIO *in, *out;
		ENGINE *e;
		int keyform, keysize;
		unsigned char *rsa_in, *rsa_out;
		int rsa_inlen, rsa_outlen;
		int rn;
		

public:

		rsa_cipher() { in=NULL;
			 out=NULL;
			 rsa=NULL;
			 pkey=NULL;
			 e=NULL;
			 keyform= FORMAT_PEM;
			 pad = RSA_PKCS1_PADDING;
			 rsa_in = NULL;
			 rsa_out = NULL;
			 rsa_inlen = 0;
			 rsa_outlen = 0;	
			 rn = 0;

	//		if(!bio_err) bio_err = BIO_new_fp(stderr, BIO_NOCLOSE);
	//		ERR_load_crypto_strings();
	//		OpenSSL_add_all_ciphers();
	//		OpenSSL_add_all_digests();



		};

		~rsa_cipher() {
			BIO_free(in);
			BIO_free_all(in);
			BIO_free(out);
			BIO_free_all(out);
			if(rsa !=NULL) RSA_free(rsa);
			}
private:	
		void 
		set_private_key(char *s) {
			private_key = s;
		}	
		void 
		set_public_key(char *s) {
			public_key = s;
		}	

public:
		int size() {
			return rn; 
		}
		int load_private_key(char *s) {
				set_private_key(s);
				
				if(!private_key ) {
					BIO_printf(bio_err,"Keyfile %s not found\n", private_key );
					ERR_print_errors(bio_err);
					return 1;
					}

				pkey = load_key(bio_err, private_key, keyform, 0, "", e, "Private Key");
				if(!pkey) {
					BIO_printf(bio_err,"No Private Key found in keyfile %s\n", private_key);
					ERR_print_errors(bio_err);
					return 1;
					}
				rsa = EVP_PKEY_get1_RSA(pkey);
				EVP_PKEY_free(pkey);
				pkey = NULL;
				if(!rsa) {
					BIO_printf(bio_err, "Error getting RSA key\n");
					ERR_print_errors(bio_err);
					rsa = NULL;
					return 1;
					}
				keysize= RSA_size(rsa);

				return 0;
		}
		
		int load_public_key(char *s) {
				set_public_key(s);
				
				if(!public_key ) {
					BIO_printf(bio_err,"Keyfile %s not found\n", public_key );
					ERR_print_errors(bio_err);
					return 1;
					}
				pkey = load_pubkey(bio_err, public_key, keyform, 0, NULL, e, "Public Key");
				if(!pkey) {
					BIO_printf(bio_err,"No Public Key found in keyfile %s\n", public_key);
					ERR_print_errors(bio_err);
					return 1;
					}
				rsa = EVP_PKEY_get1_RSA(pkey);
				EVP_PKEY_free(pkey);
				pkey = NULL;
				if(!rsa) {
					BIO_printf(bio_err, "Error getting RSA key\n");
					ERR_print_errors(bio_err);
					rsa = NULL;
					return 1;
					}
				keysize= RSA_size(rsa);
			
				return 0;
		}
		
		unsigned char *	
		encode(unsigned char *plaintext, int pn) {
				unsigned char *result = NULL;
				int resultsize;
				int i, keysizehalbe;
				rsa_in = (unsigned char *) OPENSSL_malloc(keysize * 2);
				rsa_out = (unsigned char *) OPENSSL_malloc(keysize);
				rn=0;
				if( !(in = BIO_new( BIO_s_mem() ))) {
					BIO_printf(bio_err, "Error Create Input File\n");
					ERR_print_errors(bio_err);	
					return result;
				}
				if( !(out= BIO_new( BIO_s_mem() ))) {
					BIO_printf(bio_err, "Error Create Output File\n");
					ERR_print_errors(bio_err);	
					return result;
				}

				keysizehalbe = keysize/2;
				BIO_write(in,plaintext, pn);
				for( i = 0; i < pn; i+= keysizehalbe) {
						rsa_inlen  = BIO_read(in, rsa_in , keysizehalbe );
						if(rsa_inlen <= 0) {
							BIO_printf(bio_err, "Error reading input Data\n");
							break;
						} // endif 

						rsa_outlen  = RSA_public_encrypt(rsa_inlen, rsa_in , rsa_out, rsa, pad);
				
						if(rsa_outlen <= 0) {
							BIO_printf(bio_err, "RSA operation error\n");
							ERR_print_errors(bio_err);
							break;
						}
						else
							BIO_write(out,rsa_out, rsa_outlen);
				} //endfor

				resultsize = BIO_ctrl_pending(out);
				if( resultsize > 0 ) {
						result = (unsigned char *) malloc( resultsize );
						BIO_read(out, result, resultsize);
						rn=resultsize;
				}
				if(rsa_in) OPENSSL_free(rsa_in);
				if(rsa_out) OPENSSL_free(rsa_out);
				rsa_in = NULL;
				rsa_out= NULL;
				rsa_inlen = 0;
				rsa_outlen = 0;	
				BIO_free(in);		
				in = NULL;
				BIO_free(out);		
				out = NULL;
				return result;
		}	
		
		unsigned char *	
		decrypt(const unsigned char *ciphertext, int cn) {
				unsigned char *result = NULL;
				int resultsize;
				int i ;

				rsa_in = (unsigned char *) OPENSSL_malloc(keysize * 2);
				rsa_out = (unsigned char *) OPENSSL_malloc(keysize);
				rn=0;

				if( !(in = BIO_new( BIO_s_mem() ))) {
					BIO_printf(bio_err, "Error Create Input File\n");
					ERR_print_errors(bio_err);	
					return result;
				}
				if( !(out= BIO_new( BIO_s_mem() ))) {
					BIO_printf(bio_err, "Error Create Output File\n");
					ERR_print_errors(bio_err);	
					return result;
				}
				
				BIO_write(in, ciphertext, cn);
				for( i = 0; i < cn; i+= keysize) {
						rsa_inlen  = BIO_read(in, rsa_in , keysize );
						if(rsa_inlen <= 0) {
							BIO_printf(bio_err, "Error reading input Data\n");
							break;
						} // endif 

						rsa_outlen  = RSA_private_decrypt(rsa_inlen, rsa_in , rsa_out , rsa, pad);

						if(rsa_outlen <= 0) {
							BIO_printf(bio_err, "RSA operation error\n");
							ERR_print_errors(bio_err);
							break;
						}
						else
							BIO_write(out,rsa_out, rsa_outlen);
				} //endfor

				resultsize = BIO_ctrl_pending(out);
				if( resultsize > 0 ) {
						result = (unsigned char *) malloc( resultsize );
						BIO_read(out, result, resultsize);
						rn=resultsize;
				}

				if(rsa_in) OPENSSL_free(rsa_in);
				if(rsa_out) OPENSSL_free(rsa_out);
				rsa_in = NULL;
				rsa_out= NULL;
				rsa_inlen = 0;
				rsa_outlen = 0;	
				BIO_free(in);		
				in = NULL;
				BIO_free(out);		
				out = NULL;
				return result;

		}

		
};

#endif

