/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: action.c,v 3.6 2003/04/20 21:35:28 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"

int
get_action(struct mu_op *opp)
{
	char *ptr;
	char *pattern_add;
	char *pattern_remove;

	ptr = getenv("ACTION");
	if (ptr == NULL)
		return INVALID;
	/* pattern */
	if (opp->device == net) {
		pattern_add = "register";
		pattern_remove = "unregister";
	} else {
		pattern_add = "add";
		pattern_remove = "remove";
	}

	if (strcmp(ptr,pattern_add) == 0) {
		opp->action = ACTION_ADD;
		syslog(LOG_LEVEL,"%s device is %sed",opp->device_name,ptr);
		return GOOD;
	} else if (strcmp(ptr,pattern_remove) == 0) {
		opp->action = ACTION_REMOVE;
		syslog(LOG_LEVEL,"%s device is %sd",opp->device_name,ptr);
		return GOOD;
	}
	return INVALID;
}

