/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: id.c,v 1.1 2003/04/05 20:30:40 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

#define		SEP	':'	/* changed 2.4.0-test12-pre8 */

/*
 * format: x/x
 */

static int
get_id_sub(MU_pci_id_t *id,char *ptr)
{
	char *sep;

	id->vendor = strtoul(ptr,&sep,16);
	DPRINTF(LOG_LEVEL,"vendor 0x%x",id->vendor);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	id->device = strtoul(ptr,NULL,16);
	DPRINTF(LOG_LEVEL,"device 0x%x",id->device);
	
	return GOOD;
}

int
get_id_pci_id(MU_pci_config_t *config)
{
	char *ptr;
	MU_pci_id_t id;

	ptr = getenv("PCI_ID");
	if (ptr == NULL)
		return INVALID;
	if(get_id_sub(&id,ptr) != GOOD)		/* returns must be GOOD */
		return INVALID;
	config->id = id;

	ptr = getenv("PCI_SUBSYS_ID");
	if (ptr == NULL)
		return INVALID;
	if(get_id_sub(&id,ptr) != GOOD)		/* returns must be GOOD */
		return INVALID;
	config->sub_id = id;

	return GOOD;
}
