/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: init.c,v 1.3 2003/04/05 20:31:25 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dirent.h>
#include	<fcntl.h>
#include	<string.h>
#include	<unistd.h>
#include	<ctype.h>
#include	<stdlib.h>
#include	<wait.h>

#include	"murasaki.h"

#define	PCI_PROC_DIR	"/proc/bus/pci"
#define	dprintf(arg...)	if(debug) printf(arg)
#define	IGNORE_CLASS		"0000"
#define	IGNORE_SUBSYS_ID	"0000:0000"

int debug = 0;
char *hotplug_path = NULL;

struct pci_init {
	char *	bus;
	char *	slot_fn;
	u_int16_t vendor;
	u_int16_t device;
};

void
execute_hotplug(struct pci_init *pci)
{
	char buf[256],*scratch;
	char *argv[3],*envp[16];
	int i;
	char *ptr;

	switch (fork()) {
	case -1:
		dprintf("fork error\n");
		exit(1);
	case 0:
		if (hotplug_path == NULL && (hotplug_path = get_hotplug()) == NULL)
			hotplug_path = DEFAULT_HOTPLUG;

		i = 0;
		argv[i++] = hotplug_path;
		argv[i++] = MU_ARG_PCI;
		argv[i] = 0;

		i = 0;
		scratch = buf;
		if ((ptr = getenv("MURASAKI_BEEP")) != NULL) {
			envp[i++] = ptr-14;	/* uum */
		}
		envp[i++] = "HOME=/";
		envp[i++] = "PATH=/sbin:/bin:/usr/sbin:/usr/bin";
		envp[i++] = "ACTION=add";
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_CLASS=%s",IGNORE_CLASS);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_ID=%04X:%04X",pci->vendor,pci->device);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_SUBSYS_ID=%s",IGNORE_SUBSYS_ID);
		envp[i++] = scratch;
		scratch += sprintf(scratch,"PCI_SLOT_NAME=%s:%s",pci->bus,pci->slot_fn);
		envp[i] = 0;

		execve(argv[0], argv, envp);
		break;
	default:
		wait(0);
		break;
	}

}

int
scan_device(char *dirname,struct pci_init *pci)
{
	int fd;
	char path[PATH_MAX];
	u_int16_t vendor,device;

	strcpy(path,dirname);
	strcat(path,"/");
	strcat(path,pci->slot_fn);

	if ((fd = open(path,O_RDONLY)) == -1) {
		dprintf("open error %s\n",path);
		return -1;
	}
	read(fd,&vendor,sizeof(u_int16_t));
	read(fd,&device,sizeof(u_int16_t));
	pci->vendor = vendor;
	pci->device = device;
	dprintf("bus:%s slot_fn:%s vendor:%04x device:%04x\n",
			pci->bus,pci->slot_fn,pci->vendor,pci->device);
	execute_hotplug(pci);

	close(fd);

	return 0;
}

int
scan_bus(char *dirname,struct pci_init *pci)
{
	char path[PATH_MAX];
	DIR *dir;
	struct dirent *ent;

	strcpy(path,dirname);
	strcat(path,"/");
	strcat(path,pci->bus);
	if ((dir = opendir(path)) == NULL) {
		dprintf("opendir error %s\n",path);
		return -1;
	}
	while ((ent = readdir(dir)) != NULL) {
		if (ent->d_name[0] == '.')
			continue;
		pci->slot_fn = ent->d_name;
		if (scan_device(path,pci) != 0)
			break;
	}
	closedir(dir);

	return 0;
}

int
main(int argc,char **argv)
{
	DIR *dir;
	struct dirent *ent;
	char *dirname = PCI_PROC_DIR;
	struct pci_init pci;

	if (getenv("MURASAKI_DEBUG"))
		debug = 1;

	if ((dir = opendir(dirname)) == NULL) {
		dprintf("opendir error %s\n",dirname);
		exit(1);
	}
	while ((ent = readdir(dir)) != NULL) {
		if (ent->d_name[0] == '.')
			continue;
		dprintf("dirname %s\n",ent->d_name);
		if (isdigit(ent->d_name[0]) && isdigit(ent->d_name[1])) {
			pci.bus = ent->d_name;
			scan_bus(dirname,&pci);
		}
	}
	closedir(dir);

	return 0;
}
