/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <glib.h>
#include <glib-object.h>
#ifndef __GTK_KHTML_H__
#define __GTK_KHTML_H__

/**
 * @deprecated  WARNING!  Everything in this file is deprecated.
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>

#include <webi.h>

/*
 * Type checking and casting macros
 */
#define GTK_TYPE_KHTML	(webi_get_type())
#define GTK_KHTML(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), webi_get_type(), Webi)
#define GTK_KHTML_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), webi_get_type(), Webi const)
#define GTK_KHTML_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), webi_get_type(), WebiClass)
#define GTK_IS_KHTML(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), webi_get_type ())

#define GTK_KHTML_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), webi_get_type(), WebiClass)

/* Private structure type */
typedef WebiPrivate GtkKHTMLPrivate;

/** Main object structure */
typedef Webi GtkKHTML;

/** Rendering engine settings structure
 *  Rendering engine settings structure. 
 */

typedef WebiSettings GtkKHTMLSettings;

typedef WebiLoadStatus GtkKHTMLLoadStatus;

typedef WebiPromptArgs GtkKHTMLPromptArgs;

typedef WebiAuthArgs GtkKHTMLAuthArgs;

typedef WebiClass GtkKHTMLClass;

#define GTK_KHTML_LOADING_START     WEBI_LOADING_START
#define GTK_KHTML_LOADING           WEBI_LOADING
#define GTK_KHTML_LOADING_COMPLETE  WEBI_LOADING_COMPLETE
#define GTK_KHTML_LOADING_ERROR     WEBI_LOADING_ERROR  

#define GTK_KHTML_ALERT    WEBI_ALERT
#define GTK_KHTML_CONFIRM  WEBI_CONFIRM
#define GTK_KHTML_INPUT    WEBI_INPUT


/** Returns GObject type for KHTML html renderer class
 * Returns GObject type for KHTML html renderer class.
 *
 * @return type for KHTML html renderer class 
 */
GType gtk_khtml_get_type ();


/** Creates new html rendering engine
 * Creates new html rendering engine widget. To be able to view web pages,
 * add returned widget to a container and show the container.
 * 
 * @return html rendering engine widget 
 */
GtkWidget * gtk_khtml_new ();

/** Starts loading of a new url
 * Starts loading of a new url. Loading is asynchronous.
 *
 * @emit "load-start" signal on start
 * @emit "load-stop"  signal when loading stops, ie. succesfully loaded page, or error
 * @param self the engine to use
 * @param url the url to load
 */
void gtk_khtml_load_url (GtkKHTML * self, const gchar * url);

/** Reloads current url
 * reloads current url
 */
void gtk_khtml_refresh (GtkKHTML * self);

/** Cancels the load currently in progress, if any
 * Cancels the load currently in progress, if any.
 * @emit "load-stop"
 *
 * @param self the engine to use
 */
void gtk_khtml_stop_load (GtkKHTML * self);

/** Checks the browsing history position relative to the beginning of the history
 * Checks if the engine is at the beginning of browsing history.
 * @return \TRUE if browsing history has previous elements
 *         \FALSE otherwise
 */
gboolean gtk_khtml_can_go_back (GtkKHTML * self);


/** Checks the browsing history position relative to the end of the history
 * Checks if the engine is at the end of browsing history.
 * @return \TRUE if browsing history has successive elements
 *         \FALSE otherwise
 */
gboolean gtk_khtml_can_go_forward (GtkKHTML * self);

/** Directs browser engine to the previous url in the browsing history
 * Directs browser engine to the previous url in the browsing history.
 * @emit "load-start" see \gtk_khtml_load_url
 * @emit "load-stop" see \gtk_khtml_load_url
 */
void gtk_khtml_go_back (GtkKHTML * self);

/** Directs browser engine to the next url in the browsing history
 * Directs browser engine to the next url in the browsing history.
 *
 * @emit "load-start" see \gtk_khtml_load_url
 * @emit "load-stop" see \gtk_khtml_load_url
 */
void gtk_khtml_go_forward (GtkKHTML * self);

/** Returns the url of the currently loaded page
 * Returns the url of the currently loaded page.
 * The string contains the full url used, including
 * the protocol. It can be absolute or relative.
 * The string must not be freed (const).
 *
 * @return  the url string of the currently loaded page.
 */
const gchar* gtk_khtml_get_location (GtkKHTML * self);

/** Returns the title of the currently loaded page
 * Returns the title of the currently loaded page.
 * If the page contains a frameset, title is the title of the
 * frameset.
 *
 * @return the title of the currently loaded page.
 */
const gchar* gtk_khtml_get_title (GtkKHTML * self);

/** Returns a status string set by javascript
 * Returns a string that javascript has set to be used
 * usually in the statusbar of the browser.
 *
 * @return javascript status string
 */
const gchar* gtk_khtml_get_status_text (GtkKHTML * self);

/** Returns internal representation of the engine
 * Returns internal representation of the engine.
 * Can be used in C++ code. Exposes the public NRCore api
 * to the user. This may be needed if certain functionality
 * is not implemented in C interface.
 * usage not recommended
 * Used with:
 * OSBB::Bridge* engine = 0;
 * GtkKHTML* khtml_engine = gtk_khtml_new();
 * engine = static_cast<OSB::Bridge*>(gtk_khtml_get_internal (engine));
 *
 */
void* gtk_khtml_get_internal (GtkKHTML * self);
  
/** Sets the settings of the rendering engine
 * Sets the settings of the rendering engine.
 * 
 */
void gtk_khtml_set_settings (GtkKHTML * self, const GtkKHTMLSettings* settings);

/** Returns the current settings of the rendering engine
 * Returns the current settings of the rendering engine. Fields
 * are read only and must not b
 */ 
const GtkKHTMLSettings* gtk_khtml_get_settings (GtkKHTML * self);

/**  Prints the internal render tree of the engine.
 * 
 * Can be used in C++ debug code. This 
 * usage not recommended
 * Used with:
 * GtkKHTML* khtml_engine = gtk_khtml_new();
 * const gchar * url = "http://www.mysite.com/";
 * const ghar* presentation = gtk_khtml_render_tree (engine, url));
 *
 */
const gchar* gtk_khtml_render_tree (GtkKHTML * self);

/** Toggles the emission of internal constructed load status messages
 * Sets the emission of internal constructed load status messages
 * Signalö emitted is status-text
 *
 * @param flag \TRUE if you want to receive internal status messages
                     for loading
	       \FALSE if not
 */
void gtk_khtml_set_emit_internal_status (GtkKHTML * self, gboolean flag);


void gtk_khtml_set_group (GtkKHTML* self, const gchar* group);

const gchar* gtk_khtml_get_group (GtkKHTML* self);

void gtk_khtml_set_text_multiplier (GtkKHTML* self, gfloat multiplier);
gfloat gtk_khtml_get_text_multiplier (GtkKHTML* self);

gboolean gtk_khtml_find (GtkKHTML* self, const gchar* text, gboolean case_sensitive, gboolean dir_down);

const gchar* gtk_khtml_get_current_selection_as_text(GtkKHTML* self);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
