/****************************************************************************
** $Id: qt/src/kernel/qobjectlist.h   2.3.9-snapshot-20041223   edited 2001-01-26 $
**
** Definition of QObjectList
**
** Created : 940807
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QOBJECTLIST_H
#define QOBJECTLIST_H

#ifndef QT_H
#include "qobject.h"
#include "qlist.h"
#endif // QT_H


#if defined(Q_TEMPLATEDLL)
template class Q_EXPORT QList<QObject>;
template class Q_EXPORT QListIterator<QObject>;
#endif


class Q_EXPORT QObjectList : public QList<QObject>
{
public:
    QObjectList() : QList<QObject>() {}
    QObjectList( const QObjectList &list ) : QList<QObject>(list) {}
   ~QObjectList() { clear(); }
    QObjectList &operator=(const QObjectList &list)
	{ return (QObjectList&)QList<QObject>::operator=(list); }
};

class Q_EXPORT QObjectListIt : public QListIterator<QObject>
{
public:
    QObjectListIt( const QObjectList &l ) : QListIterator<QObject>(l) {}
    QObjectListIt &operator=(const QObjectListIt &i)
	{ return (QObjectListIt&)QListIterator<QObject>::operator=(i); }
};


#endif // QOBJECTLIST_H
