/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef SIGNALSLOTEDITOR_H
#define SIGNALSLOTEDITOR_H

#include "signalsloteditor_global.h"

#include <connectionedit.h>
#include <abstractformeditor.h>
#include <abstractformwindow.h>

#include <QtXml/QDomDocument>
#include <QtXml/QDomElement>

class DomConnections;
class DomConnection;

class SignalSlotConnection : public Connection
{
    Q_OBJECT
    
public:
    SignalSlotConnection(ConnectionEdit *edit);
        
    void setSignal(const QString &signal);
    void setSlot(const QString &slot);
    
    QString sender() const;
    QString receiver() const;
    inline QString signal() const { return m_signal; }
    inline QString slot() const { return m_slot; }
    
    DomConnection *toUi() const;
    
private:    
    QString m_signal, m_slot;
};

class QT_SIGNALSLOTEDITOR_EXPORT SignalSlotEditor : public ConnectionEdit
{
public:
    SignalSlotEditor(AbstractFormWindow *form_window, QWidget *parent);
    static void registerExtensions(AbstractFormEditor *core);

    DomConnections *toUi() const;
    void fromUi(DomConnections *connections, QWidget *parent);

    AbstractFormWindow *formWindow() const { return m_form_window; }
    
protected:        
    virtual QWidget *widgetAt(const QPoint &pos) const;
    
private:    
    virtual Connection *createConnection(QWidget *source, QWidget *destination);
    
    AbstractFormWindow *m_form_window;
};

#endif // SIGNALSLOTEDITOR_H
