/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qtopia/resource.h>
#include <qtopia/config.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qstyle.h>
#include <qpainter.h>
#include <qlabel.h>
#include "loadingwidget.h"
#include "launcherview.h"


LoadingWidget::LoadingWidget( QWidget *parent, const char *name )
    : LauncherView( parent, name )
{
    docLoadingWidgetEnabled = false;
    docLoadingWidgetProgress = 0;

    hideIcons();
    QVBox *docLoadingVBox = new QVBox( this );

    docLoadingVBox->setSpacing( 20 );
    docLoadingVBox->setMargin( 10 );

    QWidget *space1 = new QWidget( docLoadingVBox );
    docLoadingVBox->setStretchFactor( space1, 1 );

    QLabel *waitPixmap = new QLabel( docLoadingVBox );
    waitPixmap->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, waitPixmap->sizePolicy().hasHeightForWidth() ) );
    waitPixmap->setPixmap( Resource::loadPixmap( "bigwait" ) );
    waitPixmap->setAlignment( int( QLabel::AlignCenter ) );

    QLabel *textLabel = new QLabel( docLoadingVBox );
    textLabel->setText( tr( "<b>Finding Documents...</b>" ) );
    textLabel->setAlignment( int( QLabel::AlignCenter ) );

    docLoadingWidgetProgress = new QProgressBar( docLoadingVBox );
    docLoadingWidgetProgress->setProgress( 0 );
    docLoadingWidgetProgress->setCenterIndicator( TRUE );

    // Still got flicker, was fixed for a bit, but this doesn't seem to be
    // the right solution without changing Qt (backport newer QProgressBar?)
    // docLoadingWidgetProgress->setBackgroundMode( NoBackground ); // No flicker

    setProgressStyle();

    QWidget *space2 = new QWidget( docLoadingVBox );
    docLoadingVBox->setStretchFactor( space2, 1 );
}

LoadingWidget::~LoadingWidget()
{
}

void LoadingWidget::setProgressStyle()
{
    if (docLoadingWidgetProgress) {
	docLoadingWidgetProgress->setFrameShape( QProgressBar::Box );
	docLoadingWidgetProgress->setFrameShadow( QProgressBar::Plain );
	docLoadingWidgetProgress->setMargin( 1 );
	docLoadingWidgetProgress->setLineWidth( 1 );
    }
}

void LoadingWidget::setEnabled( bool v )
{
    docLoadingWidgetEnabled = v;
}

void LoadingWidget::setProgress( int percent )
{
    docLoadingWidgetProgress->setProgress( percent );
}



