/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of the Qtopia Environment.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/


#include "lightdialog.h"

#include <qtopia/qpeapplication.h>
#include <qlayout.h>


LightDialog::LightDialog(QWidget *parent, const char *name, WFlags fl) 
    :QDialog(parent, name, TRUE, fl)
{
    QVBoxLayout *vBox = new QVBoxLayout(this);
    sView = new QScrollView(this);
    sView->setHScrollBarMode( QScrollView::AlwaysOff );
    sView->setResizePolicy( QScrollView::AutoOneFit );
    sView->setFrameStyle(QFrame::NoFrame);
    vBox->addWidget( sView );
    
    lSettings = new LightSettings(sView->viewport());
    sView->addChild(lSettings); 
    
}

LightDialog::~LightDialog()
{
}

void LightDialog::accept()
{
    lSettings->accept();
    QDialog::accept();
    close();
}

void LightDialog::reject()
{
    lSettings->reject();
    QDialog::reject();
    close();
}

void LightDialog::resizeEvent(QResizeEvent *) 
{
    setChildWidth();
}

void LightDialog::setChildWidth() 
{
    QSize s = lSettings->sizeHint();
    sView->resizeContents(s.width(), s.height());
    int f = sView->width() - 2*sView->frameWidth();
    if ( s.height() > height()-2 ) {
        f -= qApp->style().scrollBarExtent().width();
    }
    lSettings->setFixedWidth(f);
}
