#!/bin/sh

rotation_sw() {
    ROTA=`xrandr | grep 'Current rotation' | sed -e 's/Current rotation\ \-\ //g'`

    case "$ROTA" in
    normal)
	/etc/sysconfig/clamshell/portrait.sh
	;;
    left)
	/etc/sysconfig/clamshell/landscape.sh
	;;
    *)
	/etc/sysconfig/clamshell/landscape.sh
	;;
    esac
}

rotation_hw()
{
    MODE=`xrandr | grep '^*' | cut -f1 -d' '`
    case "$MODE" in
    *0|*1)
	/etc/sysconfig/clamshell/portrait.sh
	;;    
    *2|*3)
	/etc/sysconfig/clamshell/landscape.sh
	;;
    *)
	/etc/sysconfig/clamshell/landscape.sh
	;;
    esac
}

HARDWARE=`cat /proc/cpuinfo | grep 'Hardware' | cut -d':' -f2 | cut -d' ' -f3`

case "$HARDWARE" in
Corgi|Shepherd|Husky|Boxer)
	rotation_hw
	;;
*)
	rotation_sw
	;;
esac
