#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <glib/gi18n.h>
#include <cstdlib>

#if !defined(_WIN32) && !defined(WITHOUT_GNOME)
#  include <libgnome/libgnome.h>
#  include <libgnomeui/libgnomeui.h>
#elif defined(_WIN32)
#  include <gdk/gdkwin32.h>
#endif

#include "conf.h"
#include "stardict.h"

#include "utils.h"

void play_wav_file(const gchar *filename)
{
#ifdef _WIN32   
  PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
#elif !defined(WITHOUT_GNOME)
  gnome_sound_play(filename);
#else
  gchar *wavname=g_strdup(filename);
  gchar *argv[]={"play", wavname, NULL};
  if (!g_spawn_async(NULL, argv, NULL,
		    GSpawnFlags(G_SPAWN_SEARCH_PATH|G_SPAWN_STDOUT_TO_DEV_NULL|G_SPAWN_STDERR_TO_DEV_NULL),
		    NULL, NULL, NULL, NULL))
    g_message("g_spawn_async failes!\n");
  
  g_free(wavname);
#endif
}

void show_help(const gchar *section)
{
#ifdef _WIN32
  gchar *filename = g_strdup_printf(_("file:///%s/help/C/stardict.html"), gStarDictDataDir.c_str());
  ShellExecute((HWND)(GDK_WINDOW_HWND(gpAppFrame->oAppCore.window->window)), "OPEN", filename, NULL, NULL, SW_SHOWNORMAL);
  g_free(filename);
#elif !defined(WITHOUT_GNOME)
  gnome_help_display ("stardict.xml", section, NULL);
#endif
}

void show_url(const gchar *url)
{
#ifdef _WIN32
  ShellExecute((HWND)(GDK_WINDOW_HWND(gpAppFrame->oAppCore.window->window)), "OPEN", url, NULL, NULL, SW_SHOWNORMAL);
#elif !defined(WITHOUT_GNOME)
  gnome_url_show(url, NULL);
#endif
}

void ProcessGtkEvent(void)
{
  while (gtk_events_pending())
    gtk_main_iteration();
}
