/*
 * Execute command at an appointed survival_level.
 * (C) Copyright 2001 Lineo Japan, Inc.
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <linux/prctl.h>

#ifndef PR_GET_OOM_KILL_SURVIVAL_LEVEL
#define PR_GET_OOM_KILL_SURVIVAL_LEVEL	257
#define PR_SET_OOM_KILL_SURVIVAL_LEVEL	258
#endif

enum { MIN_LEVEL = 15 };
static char* progname;


static volatile void
usage(int code)
{
    fprintf(stderr, "usage: %s [ [-i] [-l <level>] command ...]\n", progname);
    exit(code);
}


int
main(int argc, char** argv, char** envp)
{
    int level;
    int inherit;
    char* msg;

    if (argc <= 1) {
	if (prctl(PR_GET_OOM_KILL_SURVIVAL_LEVEL, &inherit, &level) < 0) {
	    //perror("prctl");
	    //return 2;
    	    fprintf(stderr, "prctl: PR_GET_OOM_KILL_SURVIVAL_LEVEL is not supported\n");
	}
	printf("%d %d\n", inherit, level);
	return 0;
    }

    level = MIN_LEVEL;
    inherit = 0;
    progname = strdup(argv[0]);
    if (strrchr(progname, '/') != NULL) {
	progname = strrchr(progname, '/') + 1;
    }

    for (;;) {
	int ch;

	if ((ch = getopt(argc, argv, "hil:")) < 0) {
	    if (optind == argc)
		usage(2);
	    break;
	}
	switch (ch) {
	case 'h':
	    usage(0);
	    break;

	case 'i':
	    inherit = 1;
	    break;

	case 'l':
	    level = atoi(optarg);
	    if (level > MIN_LEVEL)
		level = MIN_LEVEL;
	    break;

	default:
	    return 2;
	}
    }

    if (prctl(PR_SET_OOM_KILL_SURVIVAL_LEVEL, inherit, level) < 0) {
	//perror("prctl");
	//return 2;
    	fprintf(stderr, "prctl: PR_SET_OOM_KILL_SURVIVAL_LEVEL is not supported\n");
    }

    execvp(argv[optind], &argv[optind]);
    msg = malloc(strlen(progname) + strlen(argv[optind]) + 3);
    sprintf(msg, "%s: %s", progname, argv[optind]);
    perror(msg);

    return 1;
}
