/*****************************************************************************
 * bttv.h: some bttv ioctls
 *****************************************************************************
 * $Id: bttv.h,v 1.2 2003/01/14 08:00:25 keuleu Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 *  Original code:
 *  bttv - Bt848 frame grabber driver
 *  Copyright (C) 1996,97 Ralph Metzler (rjkm@thp.uni-koeln.de)
 *  (c) 1999,2000 Gerd Knorr <kraxel@goldbach.in-berlin.de>
 *
 *****************************************************************************/
#ifndef _BTTV_H_
#define _BTTV_H_

/* bttv ioctls */
#define BTTV_READEE             _IOW('v',  BASE_VIDIOCPRIVATE+0, char [256])
#define BTTV_WRITEE             _IOR('v',  BASE_VIDIOCPRIVATE+1, char [256])
#define BTTV_FIELDNR            _IOR('v' , BASE_VIDIOCPRIVATE+2, unsigned int)
#define BTTV_PLLSET             _IOW('v' , BASE_VIDIOCPRIVATE+3, struct bttv_pll_info)
#define BTTV_BURST_ON           _IOR('v' , BASE_VIDIOCPRIVATE+4, int)
#define BTTV_BURST_OFF          _IOR('v' , BASE_VIDIOCPRIVATE+5, int)

#define BTTV_VERSION            _IOR('v' , BASE_VIDIOCPRIVATE+6, int)
  /* dirty hack time / v4l design flaw -- works with bttv only
   * this adds support for a few less common PAL versions */

#define BTTV_PICNR              _IOR('v' , BASE_VIDIOCPRIVATE+7, int)
#define BTTV_VBISIZE            _IOR('v' , BASE_VIDIOCPRIVATE+8, int)

#endif // _BTTV_H_
