/*****************************************************************************
 * fourcc.h: FOURCC definitions
 *****************************************************************************
 * $Id: fourcc.h,v 1.1 2003/01/14 08:00:39 keuleu Exp $
 *****************************************************************************
 * Copyright (C) 2002 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/
#ifndef _FOURCC_H_
#define _FOURCC_H_

// RGB formats
#define BI_RGB      0x00000000
#define RGB         (('2'<<24)|('B'<<16)|('G'<<8)|'R')
#define BI_RLE8     0x00000001
#define RLE8        (('8'<<24)|('E'<<16)|('L'<<8)|'R')
#define BI_RLE24    0x00000002
#define BI_BITFIELD 0x00000003
#define RGBA        (('A'<<24)|('B'<<16)|('G'<<8)|'R')
#define RGBT        (('T'<<24)|('B'<<16)|('G'<<8)|'R')

// Packed YUV formats
#define IYU1 (('1'<<24)|('U'<<16)|('Y'<<8)|'I')
#define IYU2 (('2'<<24)|('U'<<16)|('Y'<<8)|'I')
#define UYVY (('Y'<<24)|('V'<<16)|('Y'<<8)|'U')
#define UYNV (('V'<<24)|('N'<<16)|('Y'<<8)|'U')
#define CYUV (('V'<<24)|('U'<<16)|('Y'<<8)|'C')
#define YUY2 (('2'<<24)|('Y'<<16)|('U'<<8)|'Y')
#define YUNV (('V'<<24)|('N'<<16)|('U'<<8)|'Y')
#define YVYU (('U'<<24)|('Y'<<16)|('V'<<8)|'Y')
#define Y41P (('P'<<24)|('1'<<16)|('4'<<8)|'Y')
#define Y211 (('1'<<24)|('1'<<16)|('2'<<8)|'Y')
#define Y41T (('T'<<24)|('1'<<16)|('4'<<8)|'Y')
#define Y42T (('T'<<24)|('2'<<16)|('4'<<8)|'Y')
#define V422 (('2'<<24)|('2'<<16)|('4'<<8)|'V')
#define V655 (('5'<<24)|('5'<<16)|('6'<<8)|'V')
#define CLJR (('R'<<24)|('J'<<16)|('L'<<8)|'C')
#define YUVP (('P'<<24)|('V'<<16)|('U'<<8)|'Y')
#define UYVP (('P'<<24)|('V'<<16)|('Y'<<8)|'U')

// Planar YUV formats
#define YVU9 (('9'<<24)|('U'<<16)|('V'<<8)|'Y')
#define IF09 (('9'<<24)|('0'<<16)|('F'<<8)|'I')
#define YV12 (('2'<<24)|('1'<<16)|('V'<<8)|'Y')
#define I420 (('0'<<24)|('2'<<16)|('4'<<8)|'I')
#define IYUV (('V'<<24)|('U'<<16)|('Y'<<8)|'I')
#define CLPL (('L'<<24)|('P'<<16)|('L'<<8)|'C')

#endif // _FOURCC_H_
