/*****************************************************************************
 * $Id: mixer-common.c,v 1.5 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "mixer.h"


/* NULL means the default value of the driver */
char *mixer_dev = NULL;      /* "/dev/mixer" */
char *mixer_tvchan = NULL;   /* "line" */
char *mixer_pcmchan = NULL;  /* "pcm" */

int restoresnd = 0;

extern int cur_volume; //berk
void set_volume(void); //berk

static int cur_channel, cur_mode;

#ifdef HAVE_ALSA
extern struct MIXER mixer_alsa;
#endif
#ifdef HAVE_SUNAUDIO
extern struct MIXER mixer_sunaudio;
#endif
#ifdef HAVE_OSS
extern struct MIXER mixer_oss;
#endif
extern struct MIXER mixer_grab;
static struct MIXER *mixers[] = {
#ifdef HAVE_ALSA
  &mixer_alsa,
#endif
#ifdef HAVE_SUNAUDIO
  &mixer_sunaudio,
#endif
#ifdef HAVE_OSS
  &mixer_oss,
#endif
  &mixer_grab
};
static int mixer=-1;

void mixer_init (void) {
  for (mixer = 0;
       mixer < sizeof (mixers) / sizeof (struct MIXER *); mixer++)
    if (mixers[mixer]!=NULL && -1 != mixers[mixer]->open())
      break;
  if (mixer == sizeof (mixers) / sizeof (struct MIXER *))  {
    fprintf (stderr, "@@@@ no mixer device available\n");
    exit(1);
    /* never happens since mixer-grab is always good */
  }
  mixer_set_mode(MIXER_MODE_TVLINE); //default mode;
  fprintf(stderr, "*** MIXER DEVICE TYPE = %s\n", mixers[mixer]->name);
}

void mixer_close (void) {
  mixer_set_mute(0);
  mixers[mixer]->close();
}

int mixer_get_volume (void){
  return mixers[mixer]->get_volume(cur_channel);
}
void mixer_set_volume (int val){
  mixers[mixer]->set_volume(cur_channel, val);
}
void mixer_set_mute(int val) {
  mixers[mixer]->mute(cur_channel,val);
}

void mixer_set_mode(int mode){
  /* grab-avi uses it when it is not still initialized... */
  if(mixer==-1) return;
  cur_mode=mode;
  switch(mode) {
  case MIXER_MODE_TVLINE:
    mixers[mixer]->uncapture(); 
    cur_channel=MIXER_CHAN_TV;
    break;
  case MIXER_MODE_PCM:
    cur_channel=MIXER_CHAN_PCM;
    break;
  case MIXER_MODE_CAPTURE:
    mixers[mixer]->capture();
    cur_channel=MIXER_CHAN_TV;
    break;
  case MIXER_MODE_TV2PCM:
    mixers[mixer]->mute(MIXER_CHAN_TV,1);
    mixers[mixer]->capture();
    cur_channel=MIXER_CHAN_PCM;
  }
  cur_volume=mixer_get_volume();
  /* set_volume will automatically executes 
     mixer_set_mute(cur_mute) */
  set_volume();
}

int mixer_get_mode(void) {
  return cur_mode;
}

void disable_mixer(char *name){
  int j;
  for(j=0;j<sizeof (mixers) / sizeof (struct MIXER *);j++)
    if(mixers[j] && !strcmp(name, mixers[j]->name))
      mixers[j] = NULL;
}
