/*****************************************************************************
 * $Id: mixer-grab.c,v 1.2 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdio.h>
#include "config.h"
#include "mixer.h"
#include "grab.h"

static int tvmuted=0, tvvol=65535;
static int mixergrab_open(void) {
  return 0;
}

static void mixergrab_close(void) {}

static void mixergrab_mute (int chan, int muted) {
  if(chan!=MIXER_CHAN_TV) return;
  if(grabbers[grabber]->grab_audio)
    grabbers[grabber]->grab_audio (muted, -1, NULL);
  tvmuted=muted;
}

static int mixergrab_get_volume (int chan) {
  if(chan!=MIXER_CHAN_TV) return 0;
  return tvvol*100/65535;
}

static void mixergrab_set_volume (int chan, int val) {
  if(chan!=MIXER_CHAN_TV) return;
  tvvol=val*65535/100;
  if (grabbers[grabber]->grab_audio)
    grabbers[grabber]->grab_audio(-1, tvvol ,NULL);
}
static void mixergrab_capture(void) {}
static void mixergrab_uncapture (void) {}

struct MIXER mixer_grab = {
  "grab",
  mixergrab_open,
  mixergrab_close,
  mixergrab_mute,
  mixergrab_get_volume,
  mixergrab_set_volume,
  mixergrab_capture,
  mixergrab_uncapture
};
