/*****************************************************************************
 * messenger.c: to make xaw popup message error
 *****************************************************************************
 * $Id: stringuty.c,v 1.2 2004/10/07 06:25:07 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 *	Copyright (C) 1996/05/16(Collected) -- 1996/05/18(First Fix)
 *                    1996/05/22 -- by Nobuyuki Maruichi
 *      From mwxcd 1.32
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

 #include <stdio.h>
 #include <stdlib.h>
 #include <ctype.h>
 #include <stdarg.h>

#include <X11/Intrinsic.h>	/* Intrinsics Definitions */
#include <X11/StringDefs.h>	/* Standard Name-String definitions */

#include "stringuty.h"

#ifndef	_XtIntrinsic_h

char *NewString(const char *string)
{
	char *alloc_ptr = NULL;

	alloc_ptr = (char*)malloc(strlen(string)+1);
	return(alloc_ptr);
}

# define	_string_malloc(size)		malloc(size)
# define	_string_newString(string)	NewString(string)
# define	_string_free(pointer)		free(pointer)
#else

# define	_string_malloc(size)		XtMalloc(size)
# define	_string_newString(string)	XtNewString(string)
# define	_string_free(pointer)		XtFree((char*)pointer)
#endif	/*_XtIntrinsic_h*/

int asciiStringCaseCmp(const char *s1, const char *s2)
{
	int c1, c2;
	int result = 0;

	if(s1 != NULL && s2 != NULL) {
		for(;result == 0 && *s1 != '\0' && *s2 != '\0';++s1, ++s2) {
			if(isalpha(*s1) && isalpha(*s2)) {
				c1 = tolower(*s1);
				c2 = tolower(*s2);
				result = -(c1 < c2) + (c1 > c2);
			} else {
				result = -(*s1 < *s2) + (*s1 > *s2);
			}
		}
		if(result == 0 && (*s1 != '\0' || *s2 != '\0')) {
			result = -(*s1 < *s2) + (*s1 > *s2);
		}
	}
	return(result);
}

LineLink *lineAlloc(const char *string)
{
	LineLink *alloc_ptr = NULL;

	alloc_ptr = (LineLink*)_string_malloc(sizeof(LineLink));
	if(alloc_ptr != NULL) {
		if(string != NULL) {
			alloc_ptr->string = (char*)_string_newString(string);
		} else {
			alloc_ptr->string = NULL;
		}
		alloc_ptr->next_ptr = NULL;
	}
	return(alloc_ptr);
}

void lineFree(LineLink *release_ptr)
{
	extern int debug;
	if(release_ptr != NULL) {
		if (debug)
  	  	  printf("%s\n", release_ptr->string);
		_string_free(release_ptr->string);
		_string_free(release_ptr);
	}
}

void linesRelease(LineLink *lines)
{
	LineLink *release_ptr;

	while(lines != NULL) {
		release_ptr = lines;
		lines = lines->next_ptr;
		lineFree(release_ptr);
	}
}

LineLink *string2lines(const char *string)
{
	int length;
	int loopExit = True;
	const char *line_ptr, *line_end_ptr;
	LineLink *alloc_ptr = NULL, *allocTop;
	extern int debug;

	line_ptr = string;
	allocTop = alloc_ptr = lineAlloc(NULL);
	do {
		loopExit = True;
		line_end_ptr = strchr(line_ptr, '\n');
		length = ((line_end_ptr != NULL)?
						(line_end_ptr-line_ptr+1):(strlen(line_ptr)));
		alloc_ptr->string = (char*)_string_malloc(length+1);
		if(alloc_ptr->string != NULL) {
			sprintf(alloc_ptr->string, "%.*s", length, line_ptr);
		if (debug)
		{
  			printf("%s\n", alloc_ptr->string);
			fflush(stdout);
  		}
			alloc_ptr->next_ptr = lineAlloc(NULL);
		}
		if(line_end_ptr != NULL && alloc_ptr->next_ptr != NULL) {
			line_ptr = line_end_ptr + (*line_end_ptr == '\n');
			alloc_ptr = alloc_ptr->next_ptr;
			loopExit = False;
		}
	} while(loopExit == False);
	_string_free(alloc_ptr->next_ptr);
	alloc_ptr->next_ptr = NULL;
	return(allocTop);
}

LineLink *linesConnect(LineLink *lines1, LineLink *lines2)
{
	LineLink *lines_ptr;

	if(lines1 != NULL) {
		lines_ptr = lines1;
		while(lines_ptr->next_ptr != NULL) {
			lines_ptr = lines_ptr->next_ptr;
		}
		lines_ptr->next_ptr = lines2;
	} else {
		lines1 = lines2;
	}
	return(lines1);
}

int linesLength(LineLink *strings)
{
	int counter;

	counter = 0;
	while(strings != NULL) {
		counter += strlen(strings->string);
		strings = strings->next_ptr;
	}
	return(counter);
}

String lines2string(LineLink *strings)
{
	int counter;
	size_t length;
	String textString;

	length = linesLength(strings);
	textString = _string_malloc(length + 1);
	for(counter = 0, *textString = '\0';strings != NULL &&
			counter+strlen(strings->string) <= length;
			counter+=strlen(strings->string), strings=strings->next_ptr) {
		strcat(textString, strings->string);
	}
	return(textString);
}

int linesTextLength(LineLink *strings)
{
	int counter;

	counter = 0;
	while(strings != NULL) {
		counter += strcspn(strings->string, "\n\r") + 1;
		strings = strings->next_ptr;
	}
	return(counter);
}

String lines4textString(LineLink *strings)
{
	int counter;
	size_t length;
	String textString;

	length = linesTextLength(strings);
	textString = _string_malloc(length + 2);
	for(counter = 0, *textString = '\0';strings != NULL &&
		counter+(strcspn(strings->string,"\b\n\r")+1) <= length;
		counter+=(strcspn(strings->string,"\b\n\r")+1), strings=strings->next_ptr) {
		strcat(textString, strings->string);
		strcpy(textString+counter+strcspn(strings->string,"\b\n\r"), "\n");
	}
	return(textString);
}

LineLink *file2lines(FILE *stream)
{
	char buffer[4096];
	const char *line;
	LineLink *alloc_ptr = NULL, allocTop;

	alloc_ptr = &allocTop;
	while(line = fgets(buffer, sizeof(buffer), stream), line != NULL) {
		alloc_ptr->next_ptr = lineAlloc(NULL);
		line = (char*)alloc_ptr->next_ptr;
		if(alloc_ptr->next_ptr != NULL) {
			alloc_ptr->next_ptr->string = _string_newString(buffer);
			if(alloc_ptr->next_ptr->string != NULL) {
				alloc_ptr = alloc_ptr->next_ptr;
			} else {
				break;
			}
		}
	}
	alloc_ptr->next_ptr = NULL;
	return(allocTop.next_ptr);
}

void lines2file(const LineLink *lines, FILE *stream)
{
	while(lines != NULL) {
		fputs(lines->string, stream);
		lines = lines->next_ptr;
	}
}

int countLines(LineLink *strings)
{
	int counter;

	counter = 0;
	while(strings != NULL) {
		++counter;
		strings = strings->next_ptr;
	}
	return(counter);
}

char **lines2stringArray(LineLink *strings, void (*convertString)(char *string))
{
	int arrays, counter;
	char **string_ptr_ptr;

	arrays = countLines(strings);
	++arrays;
	string_ptr_ptr = (char**)_string_malloc(sizeof(*string_ptr_ptr) * arrays);
	if(string_ptr_ptr != NULL) {
		memset(string_ptr_ptr, 0x00, sizeof(*string_ptr_ptr) * arrays);
		counter = 0;
		while(strings != NULL) {
			if(convertString != NULL) {
				convertString(strings->string);
			}
			*(string_ptr_ptr+counter) = strings->string;
			++counter;
			strings = strings->next_ptr;
		}
	}
	return(string_ptr_ptr);
}

int arrayCount(XtPointer *pointerArray)
{
	int counter;

	counter = 0;
	while(*(pointerArray+counter) != NULL) {
		++counter;
	}
	return(counter);
}

void nullTerminatedPointerArrayFree(void **pointerArray)
{
	int counter;

	if(pointerArray != NULL) {
		for(counter = 0;*(pointerArray+counter) != NULL;++counter) {
			_string_free(*(pointerArray + counter));
		}
		_string_free((char*)pointerArray);
	}
}

int searchInStringArray(const char *target, int limit, const char **names, int (*compare)(const char *s1, const char *s2))
{
	int counter;

	if(compare == NULL) {
		compare = strcmp;
	}
	for(counter = 0;counter < limit;++counter) {
		if(compare(*(names + counter), target) == 0) {
			return(counter);
		}
	}
	return(EOF);
}

int searchInStringPointerArray(const char *target, const char **names, int (*compare)(const char *s1, const char *s2))
{
	int counter;

	if(compare == NULL) {
		compare = strcmp;
	}
	for(counter = 0;*(names + counter) != NULL;++counter) {
		if(compare(*(names + counter), target) == 0) {
			return(counter);
		}
	}
	return(EOF);
}

int VCreatePointorsLink(PointorsLink **linkBuffer, va_list argument)
{
	int argc;
	void *argv;
	PointorsLink *topList = NULL;
	PointorsLink *previousLink = NULL;
	PointorsLink *currentLink = NULL;

	argc = 0;
	argv = &argv;

	while(argv != NULL) {

		argv = va_arg(argument, void*);

		if(argv != NULL) {

			++argc;
			currentLink = (PointorsLink*)XtMalloc(sizeof(PointorsLink));
			currentLink->data_ptr = argv;
			currentLink->type_pointer = NULL;
			currentLink->bufferSize = 0;
			currentLink->prevLink = previousLink;
			currentLink->nextLink = NULL;
			currentLink->typeName[0] = '\0';
			if(currentLink->prevLink != NULL) {

				currentLink->prevLink->nextLink = currentLink;
			} else {
				topList = currentLink;
			}
		}

		previousLink = currentLink;
	}
	if(topList != NULL) {

		*linkBuffer = topList;
	}

	return(argc);
}

int VaCreatePointorsLink(PointorsLink **linkBuffer, ...)
{
	int argc;
	va_list argument;

	va_start(argument, linkBuffer);
	argc = VCreatePointorsLink(linkBuffer, argument);
	va_end(argument);

	return(argc);
}

int VaGetPointorsLink(const PointorsLink *linkBuffer, ...)
{
	int argc;
	void **argv_ptr;
	va_list argument;
	const PointorsLink *currentLink = linkBuffer;

	va_start(argument, linkBuffer);

	argc = 0;
	argv_ptr = (void**)&argv_ptr;

	while(linkBuffer != NULL && argv_ptr != NULL) {

		argv_ptr = va_arg(argument, void**);

		if(argv_ptr != NULL) {

			++argc;
			*argv_ptr   = currentLink->data_ptr;
			currentLink = currentLink->nextLink;
		}
	}
	va_end(argument);

	return(argc);
}

PointorsLink *ValuesLinkAlloc(size_t size, void *value, const char *type)
{
	size_t bufferSize;
	PointorsLink *alloc_ptr;

	if(size == EOF) {
		size = strlen(value) + 1;
	}
	bufferSize = sizeof(PointorsLink) + strlen(type);
	if(size > 0) {
		bufferSize += size;
	}
	alloc_ptr = (PointorsLink*)XtMalloc(bufferSize);
	strcpy(alloc_ptr->typeName, type);
	alloc_ptr->type_pointer = alloc_ptr->typeName;
	if(size > 0) {

		alloc_ptr->bufferSize = size;
		alloc_ptr->data_ptr =
				(void*)(alloc_ptr->typeName + strlen(type) + 1);
		memcpy(alloc_ptr->data_ptr, value, size);
	} else {

		alloc_ptr->data_ptr = value;
		/*alloc_ptr->type_pointer = NULL;*/
		alloc_ptr->bufferSize = 0;
	}
	alloc_ptr->prevLink = NULL;
	alloc_ptr->nextLink = NULL;
	return(alloc_ptr);
}

void connectValuesLink(PointorsLink *insTarget, PointorsLink *previous, PointorsLink *next)
{
	if(insTarget != NULL) {
		insTarget->prevLink = previous;
		insTarget->nextLink = next;
	} else {
		insTarget = next;
		if(insTarget != NULL) {
			insTarget->prevLink = previous;
		}
		next = NULL;
	}
	if(previous != NULL) {

		previous->nextLink = insTarget;
	}
	if(next != NULL) {

		next->prevLink = insTarget;
	}
}

int VCreateValuesLink(PointorsLink **linkBuffer, va_list argument)
{
	int argc;
	size_t argSize;
	void *argValue;
	const char *argType;
	PointorsLink *topList = NULL;
	PointorsLink *previousLink = NULL;
	PointorsLink *currentLink = NULL;

	argc = 0;
	argType = (const char*)&argType;

	while(argType != NULL) {

		argType = va_arg(argument, const char*);

		if(argType != NULL) {

			++argc;
			argValue = va_arg(argument, void*);
			argSize  = va_arg(argument, size_t);
			currentLink = ValuesLinkAlloc(argSize, argValue, argType);
			connectValuesLink(currentLink, previousLink, NULL);
			if(topList == NULL) {
				topList = currentLink;
			}
		}

		previousLink = currentLink;
	}
	if(topList != NULL) {

		*linkBuffer = topList;
	}

	return(argc);
}

int VaCreateValuesLink(PointorsLink **linkBuffer, ...)
{
	int argc;
	va_list argument;

	va_start(argument, linkBuffer);
	argc = VCreateValuesLink(linkBuffer, argument);
	va_end(argument);

	return(argc);
}

const void *terminalSearch(const void *client_data, const void *(*nextStep)(const void *pointer))
{
	const void *result_ptr = NULL;
	const void *next_ptr = client_data;

	while(next_ptr != NULL) {
		result_ptr = next_ptr;
		next_ptr = nextStep(next_ptr);
	}
	return(result_ptr);
}

int terminalCount(const void *client_data, const void *(*nextStep)(const void *pointer))
{
	int counter;
	const void *next_ptr = client_data;

	if(client_data == NULL) {
		return(EOF);
	}
	for(counter = 0, next_ptr = nextStep(next_ptr);
				next_ptr != NULL;++counter, next_ptr = nextStep(next_ptr))
		;
	return(counter);
}

const void *numSearch(const void *client_data, int no, const void *(*nextStep)(const void *pointer))
{
	int counter;
	const void *current_ptr = client_data;

	for(counter = 0;counter < no && current_ptr != NULL;++counter) {
		current_ptr = nextStep(current_ptr);
	}
	return(current_ptr);
}

const void *prevPointersLink(const void *pointer)
{
	PointorsLink *current = (PointorsLink*)pointer;

	return((const void*)current->prevLink);
}

const void *nextPointersLink(const void *pointer)
{
	PointorsLink *current = (PointorsLink*)pointer;

	return((const void*)current->nextLink);
}

int VaAddValuesLink(PointorsLink **linkTop, ...)
{
	int argc;
	va_list argument;
	PointorsLink *linkLast;
	PointorsLink *linkBuffer;

	va_start(argument, linkTop);
	argc = VCreateValuesLink(&linkBuffer, argument);
	va_end(argument);
	if(linkTop == NULL) {
		*linkTop = linkBuffer;
	} else {
		linkLast = (PointorsLink*)terminalSearch(*linkTop, nextPointersLink);
		connectValuesLink(NULL, linkLast, linkBuffer);
	}

	return(argc);
}

void *getValuesLink(size_t argSize, void *argValue, const char *argType, const PointorsLink *currentLink)
{
	switch(argSize) {
	case EOF:
		argValue = XtMalloc(currentLink->bufferSize);
		memcpy(argValue, currentLink->data_ptr, currentLink->bufferSize);
		break;
	case 0:
		argValue = currentLink->data_ptr;
		break;
	default:
		if(argSize > 0 && currentLink->bufferSize <= argSize) {
			argSize = currentLink->bufferSize;
			memcpy(argValue, currentLink->data_ptr, argSize);
		} else {
			fprintf(stderr, "getValuesLink(); : Fatal Error.\n");
		}
		break;
	}
	return(argValue);
}

int VGetValuesLink(const PointorsLink *linkBuffer, va_list argument)
{
	int argc;
	size_t argSize;
	void **argValue_ptr;
	const char *argType;
	const PointorsLink *currentLink = linkBuffer;

	argc = 0;
	argType = (const char*)&argType;

	while(argType != NULL) {

		argType = va_arg(argument, const char*);

		if(argType != NULL) {

			++argc;
			argValue_ptr = va_arg(argument, void**);
			argSize  = va_arg(argument, size_t);

			if(currentLink->type_pointer != NULL && *argType != '\0' &&
						*(currentLink->type_pointer) != '\0' &&
								strcmp(currentLink->typeName, argType)) {

				fprintf(stderr, "Argument type is wrong!!\n");
				continue;
			}
			switch(argSize) {
			case EOF:
				*argValue_ptr = XtMalloc(currentLink->bufferSize);
				memcpy(*argValue_ptr,
					currentLink->data_ptr, currentLink->bufferSize);
				break;
			case 0:
				*argValue_ptr = currentLink->data_ptr;
				break;
			default:
				if(argSize > 0 && currentLink->bufferSize < argSize) {
					argSize = currentLink->bufferSize;
					memcpy(*argValue_ptr, currentLink->data_ptr, argSize);
				}
				break;
			}
			currentLink = currentLink->nextLink;
		}
	}
	return(argc);
}

int VaGetValuesLink(const PointorsLink *linkBuffer, ...)
{
	int argc;
	va_list argument;

	va_start(argument, linkBuffer);

	argc = VGetValuesLink(linkBuffer, argument);

	va_end(argument);

	return(argc);
}

int VaGetAbsValuesLink(const PointorsLink *linkBuffer, int step, ...)
{
	int argc = 0;
	va_list argument;

	va_start(argument, step);

	linkBuffer = (PointorsLink*)terminalSearch(linkBuffer, prevPointersLink);
	linkBuffer =
		(const PointorsLink*)numSearch(linkBuffer, step, nextPointersLink);
	if(linkBuffer != NULL) {
		argc = VGetValuesLink(linkBuffer, argument);
	}

	va_end(argument);

	return(argc);
}


int VaGetRelValuesLink(const PointorsLink *linkBuffer, int step, ...)
{
	int argc = 0;
	va_list argument;
	const void *(*linkStep[2])(const void *pointer) = {prevPointersLink, nextPointersLink};

	va_start(argument, step);

	linkBuffer = (const PointorsLink*) numSearch(linkBuffer, step, linkStep[(step >= 0)]);
	if(linkBuffer != NULL) {
		argc = VGetValuesLink(linkBuffer, argument);
	}

	va_end(argument);

	return(argc);
}

int VaCountPointorsLink(PointorsLink *linkBuffer)
{
	int counter = 0;

	while(linkBuffer != NULL && linkBuffer->prevLink != NULL) {
		linkBuffer = linkBuffer->prevLink;
	}
	while(linkBuffer != NULL) {
		++counter;
		linkBuffer = linkBuffer->nextLink;
	}
	return(counter);
}

void VaDestroyPointorsLink(PointorsLink *linkBuffer)
{
	PointorsLink *release_ptr;

	while(linkBuffer != NULL && linkBuffer->prevLink != NULL) {
		linkBuffer = linkBuffer->prevLink;
	}
	while(linkBuffer != NULL) {
		release_ptr = linkBuffer;
		linkBuffer = linkBuffer->nextLink;
		XtFree((char*)release_ptr);
	}
}

void *cutoffPointorsLink(PointorsLink **linkBuffer)
{
	void *result_ptr = NULL;
	PointorsLink *release_ptr;

	if(linkBuffer != NULL && *linkBuffer != NULL) {
		release_ptr = *linkBuffer;
		result_ptr  = release_ptr->data_ptr;
		*linkBuffer = release_ptr->nextLink;
		if(*linkBuffer != NULL) {
			(*linkBuffer)->prevLink = NULL;
		}
		XtFree((char*)release_ptr);
	}
	return(result_ptr);
}

