/*****************************************************************************
 * xdtv_serv.c: get commands for xdtv
 *****************************************************************************
 * $Id: xdtv_serv.c,v 1.1 2004/09/08 21:03:50 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2003 Alain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/



#include <stdio.h>
#include <unistd.h>

#include <X11/Intrinsic.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdlib.h> 
#include "commands.h"

#define MAX_CMD 10000
static int sock=0;
static XtInputId socket_id;
extern XtAppContext app_context;

/* pour le socket */
static char sockname[80];
int init_socket1(void) {
  struct sockaddr_un addr;
  int ret;
  sprintf (sockname, "%.60s/.xdtv/socket", getenv ("HOME"));
  unlink(sockname);
  sock=socket(AF_UNIX,SOCK_STREAM,0);
  if(sock<0) {perror("socket");sock=0;return 0;}
  addr.sun_family=AF_UNIX;
  strcpy(addr.sun_path,sockname);
  ret=bind(sock,(struct  sockaddr*)&addr,sizeof(addr));
  if(ret<0) {perror("bind"); close(sock); sock=0;return 0;};
  ret=listen(sock,5);
  if(ret) {perror("listen"); close(sock); sock=0;return 0;}
  return 1;
}

static void read_socket(XtPointer data, int *fd, XtInputId *iproc) {
  char cmd[MAX_CMD];
  int lus=0,nr,sock2;
  if(*fd!=sock) {fprintf(stderr,"gros probleme dans read_socket\n");return;}
  sock2=accept(sock,NULL,NULL);
  if(sock2<0) {perror("accept");return;}
  do {
    nr=read(sock2,cmd+lus,MAX_CMD-lus);
    lus+=nr;
    if(nr<0) {perror("read");close(sock2);return;}
  } while(nr>0 && lus<MAX_CMD);
  if(lus==MAX_CMD) {fprintf(stderr,"commande trop longue");close(sock2);return;}
  cmd[lus]='\0';
  do_command(cmd);
}

void close_socket(void) {
  if(!sock) return;
  XtRemoveInput(socket_id);
  close(sock);
  if(unlink(sockname)) perror("unlink");
}

void init_socket(void) {
  if(init_socket1())
    socket_id=XtAppAddInput(app_context,sock,(XtPointer)XtInputReadMask,
			    read_socket,NULL);
  else
    fprintf(stderr,"socket deja existant ?\n");
}

