/*****************************************************************************
 * xdtv_wizard.c: wizard for xdtv to test some of it functions
 *****************************************************************************
 * $Id: xdtv_wizard.c,v 1.5 2004/10/07 21:13:47 pingus77 Exp $
 *****************************************************************************
 * wizard.c is based on bs.c public domain software
 * Luiz Henrique de Figueiredo (lhf@visgraf.impa.br)
 * simple button shell for X11
 * 05 Nov 1992
 * small updates for xdtv: 02 jul 2003
 *****************************************************************************/

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "config.h"
#include <X11/Shell.h>

#ifdef HAVE_XPM
# include <X11/xpm.h>
# include "xdtv.xpm"
#ifdef HAVE_PIXMAPS
#include "../pixmaps/popup_infos.xpm"
#endif
#endif

typedef void Callback(Widget w, XtPointer client_data, XtPointer call_data);

void	doargs		(int argc, char* argv[]);
void	makemenu	(void);
void	execute		(char* s);
Widget	addlabel	(char* label);
Widget	addbutton	(char* label, Callback* f, char* p);
void	do_it		(Widget w, XtPointer client_data, XtPointer call_data);
void	do_quit		(Widget w, XtPointer client_data, XtPointer call_data);

static	Widget		toplevel;
static	Widget		form;
static	Widget		wh=NULL;
static	Widget		wv=NULL;
static	Widget		c_quit; 
static	FILE*		shell;
static	Atom		wm_delete_window;

#define	getline(s)	fgets(s,sizeof(s),stdin) 

void 
Quit(Widget widget, XEvent * event, String * params, Cardinal * num_params)
{
  XCloseDisplay(XtDisplay(widget));
  exit(0);
}

XtActionsRec xdtv_wizard_actions[] = {
  {"Quit", Quit},
};

int main(int argc, char* argv[])
{
 XrmDatabase rdb;

#ifdef HAVE_XPM
 Pixmap icon_pixmap;
 Pixmap icon_shapemask;
#endif

 shell=popen("/bin/sh","w");
 doargs(argc,argv);

 XtAddActions (xdtv_wizard_actions, sizeof (xdtv_wizard_actions) / sizeof (XtActionsRec)); 
  
 rdb = XtDatabase(XtDisplay(toplevel)); 
 XrmPutStringResource(&rdb, "XawWiz*background",    "white");
 XrmPutStringResource(&rdb, "XawWiz*foreground",    "black");
 XrmPutStringResource(&rdb, "XawWiz*Command.translations", "#override\n<EnterWindow>: highlight()\n<LeaveWindow>: reset()");
 XrmPutStringResource(&rdb, "XawWiz*form.translations", "#override\n<Key>Escape: Quit()\n<Key>q: Quit()\n<Key>Return: Quit()");
 
 execute("cd $HOME\n");
 makemenu();
 
#ifdef HAVE_XPM
 XpmCreatePixmapFromData(XtDisplay(toplevel),
                          RootWindowOfScreen(XtScreen(toplevel)),
                          icon_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
 XtVaSetValues(toplevel, XtNiconPixmap, icon_pixmap, NULL);
#ifdef HAVE_PIXMAPS 
 XpmCreatePixmapFromData(XtDisplay(toplevel),
                          RootWindowOfScreen(XtScreen(toplevel)),
                          popup_infos_xpm,
                          &icon_pixmap,
                          &icon_shapemask, NULL);
  XtVaSetValues(c_quit, XtNbitmap, icon_pixmap, NULL); 
#endif
#endif

 XtRealizeWidget(toplevel);
 
 wm_delete_window = XInternAtom(XtDisplay(toplevel), "WM_DELETE_WINDOW",False);
 XtOverrideTranslations (toplevel, XtParseTranslationTable ("<Message>WM_PROTOCOLS: Quit()"));
 XSetWMProtocols (XtDisplay (toplevel), XtWindow (toplevel), &wm_delete_window , 1);
 XtInstallAllAccelerators (form, toplevel);
  
 XtMainLoop();
 return 0;
} 

void doargs(int argc, char* argv[])
{
 char* f;
 toplevel=XtInitialize(argv[0],"XawWiz",NULL,0,&argc,argv);
 switch (argc)
 {
  case 1:
   f="/etc/xdtv_wizard.conf";
   break;
  case 2:
   f=argv[1];
   break;
  default:
   fprintf(stderr,"usage: xdtv_wizard [menu-file-with-path] [X toolkit options]\n");
   exit(1);
 }
 if (freopen(f,"r",stdin)==NULL)
 {
  fprintf(stderr,"xdtv_wizard: cannot open ");
  perror(f);
  exit(1);
 }
}

void makemenu(void)
{
 char s[BUFSIZ];
 form=XtCreateManagedWidget("form",formWidgetClass,toplevel,NULL,0);
 
 while (getline(s))
 {
  char* t;
  if (*s=='\n')				/* empty line: new row */
  {
   if (wh!=NULL)
   {
    wv=wh;
    wh=NULL;
   }
   continue;
  }
  t=strchr(s,'\t');
  if (t==NULL)				/* empty command: label */
   wh=addlabel(s);
  else if (t==s)			/* empty label: prolog */
   execute(s);
  else
  {
   *t++=0;
   wh=addbutton(s,do_it,t);
  }
 }
 
 c_quit = XtVaCreateManagedWidget("Close",commandWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	NULL);
 XtAddCallback(c_quit, XtNcallback, do_quit, NULL);
 
}

void execute(char* s)
{
 fputs(s,shell);
 fflush(shell);
}

Widget addlabel(char* label)
{
 Widget w=XtVaCreateManagedWidget(label,labelWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	XtNborderWidth,	(XtArgVal) 0,
	NULL);
 return w;
}

Widget addbutton(char* label, Callback* f, char* p)
{
 Widget w=XtVaCreateManagedWidget(label,commandWidgetClass,form,
	XtNfromHoriz,	(XtArgVal) wh,
	XtNfromVert,	(XtArgVal) wv,
	NULL);
 XtAddCallback(w,XtNcallback,f,XtNewString(p));
 return w;
}



void do_it(Widget w, XtPointer client_data, XtPointer call_data)
{
 execute(client_data);
}

void do_quit(Widget w, XtPointer client_data, XtPointer call_data)
{
 pclose(shell);
 exit(0);
}

