/*
 * xmms-mad - mp3 plugin for xmms
 * Copyright (C) 2001-2002 Sam Clegg - See COPYING
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $superduper: configure.c,v 1.6 2005/03/12 01:09:57 sam Exp $
 */
#include "xmms-mad.h"

#include <gtk/gtk.h>
#include <math.h>
#include <xmms/configfile.h>

static GtkWidget *configure_win = NULL;
static GtkWidget *vbox;
static GtkWidget *fast_playback, *use_xing, *dither;
static GtkWidget *RG_enable, *RG_track_mode, *RG_default, *pregain, *hard_limit;

static void
configure_win_ok (GtkWidget *widget, gpointer data)
{
  ConfigFile *cfg;
  const gchar *text=NULL;

#ifdef DEBUG
  g_messadge("saving\n");
#endif

  xmmsmad_config.fast_play_time_calc = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fast_playback));
  xmmsmad_config.use_xing = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_xing));
  xmmsmad_config.dither = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dither));

  xmmsmad_config.replaygain.enable = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(RG_enable));
  xmmsmad_config.replaygain.track_mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(RG_track_mode));
  xmmsmad_config.hard_limit = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hard_limit));
  text = gtk_entry_get_text (GTK_ENTRY (RG_default));
  xmmsmad_config.replaygain.default_db = g_strdup(text);

  text = gtk_entry_get_text (GTK_ENTRY (pregain));
  xmmsmad_config.pregain_db = g_strdup(text);

  xmmsmad_config_compute(&xmmsmad_config);

  cfg = xmms_cfg_open_default_file();
  if (!cfg)
    cfg = xmms_cfg_new ();
  xmms_cfg_write_int(cfg, "MAD", "http_buffer_size", xmmsmad_config.http_buffer_size);
  xmms_cfg_write_boolean(cfg, "MAD", "fast_play_time_calc", xmmsmad_config.fast_play_time_calc);
  xmms_cfg_write_boolean(cfg, "MAD", "use_xing", xmmsmad_config.use_xing);
  xmms_cfg_write_boolean(cfg, "MAD", "dither", xmmsmad_config.dither);
  xmms_cfg_write_boolean(cfg, "MAD", "hard_limit", xmmsmad_config.hard_limit);
  xmms_cfg_write_string(cfg, "MAD", "pregain_db", xmmsmad_config.pregain_db);

  xmms_cfg_write_boolean(cfg, "MAD", "RG.enable", xmmsmad_config.replaygain.enable);
  xmms_cfg_write_boolean(cfg, "MAD", "RG.track_mode", xmmsmad_config.replaygain.track_mode);
  xmms_cfg_write_string(cfg, "MAD", "RG.default_db", xmmsmad_config.replaygain.default_db);
  xmms_cfg_write_default_file (cfg);
  xmms_cfg_free (cfg);
  gtk_widget_destroy (configure_win);
}

static void
configure_destroy (GtkWidget *w, gpointer data)
{
}

void
xmmsmad_configure (void)
{
  GtkWidget *bbox, *ok, *cancel;
  GtkWidget *label, *RG_default_hbox, *pregain_hbox;

  if (configure_win != NULL)
    {
      gdk_window_raise(configure_win->window);
      return;
    }

  configure_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT(configure_win), "destroy",
      GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);
  gtk_signal_connect (GTK_OBJECT(configure_win), "destroy",
      GTK_SIGNAL_FUNC(configure_destroy), &configure_win);
  gtk_window_set_title(GTK_WINDOW(configure_win), "MAD Input Plugin Configuration");
  gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
  gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

  vbox = gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(configure_win), vbox);

  fast_playback = gtk_check_button_new_with_label("Use fast playtime calculation");
  gtk_box_pack_start(GTK_BOX(vbox), fast_playback, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fast_playback), 
      xmmsmad_config.fast_play_time_calc);

  use_xing = gtk_check_button_new_with_label("Parse XING headers");
  gtk_box_pack_start(GTK_BOX(vbox), use_xing, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_xing), xmmsmad_config.use_xing);

  dither = gtk_check_button_new_with_label("Dither output when rounding to 16-bit");
  gtk_box_pack_start(GTK_BOX(vbox), dither, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dither), xmmsmad_config.dither);

  /* SKR added config : */
  RG_enable = gtk_check_button_new_with_label("Enable replaygain");
  gtk_box_pack_start(GTK_BOX(vbox), RG_enable, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(RG_enable),
                               xmmsmad_config.replaygain.enable);
  RG_track_mode = gtk_check_button_new_with_label("Prefer TRACK replaygain");
  gtk_box_pack_start(GTK_BOX(vbox), RG_track_mode, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(RG_track_mode),
                               xmmsmad_config.replaygain.track_mode);

  hard_limit = gtk_check_button_new_with_label("hard-limit samples (prevent clipping)");
  gtk_box_pack_start(GTK_BOX(vbox), hard_limit, TRUE, TRUE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hard_limit),
                               xmmsmad_config.hard_limit);

  label = gtk_label_new("gain to use if no RG tag (dB):");
  RG_default_hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), RG_default_hbox, TRUE, TRUE, 0);
  RG_default = gtk_entry_new ();
  gtk_widget_set_usize(RG_default, 80, -1);
  gtk_entry_set_text (GTK_ENTRY(RG_default), xmmsmad_config.replaygain.default_db);
  gtk_box_pack_start(GTK_BOX(RG_default_hbox), label, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(RG_default_hbox), RG_default, FALSE, TRUE, 0);

  label = gtk_label_new("Pre-gain (dB):");
  pregain_hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), pregain_hbox, TRUE, TRUE, 0);
  pregain = gtk_entry_new ();
  gtk_widget_set_usize(pregain, 80, -1);
  gtk_entry_set_text (GTK_ENTRY(pregain), xmmsmad_config.pregain_db);
  gtk_box_pack_start(GTK_BOX(pregain_hbox), label, FALSE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(pregain_hbox), pregain, FALSE, TRUE, 0);


  bbox = gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
  gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

  ok = gtk_button_new_with_label("Ok");
  gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(configure_win_ok), NULL);
  GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
  gtk_widget_grab_default(ok);

  cancel = gtk_button_new_with_label("Cancel");
  gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", 
      GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
  GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);

  gtk_widget_show_all(configure_win);
}
