/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 1997-2005  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "swindow/SCanvas.h"

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 * This is the abstract widget toolkit package
 */

/**
 * This class is meant to be the base class of canvases
 * enum SState { DRAW, CACHE, FLUSH };
 * <ul>
 *  <li> DRAW - use direct printing (default)</li>
 *  <li> CACHE - use cacheStart , cahceEnd and draw in between</li>
 *  <li> FLUSH - use cachePrint to print the cahced item.</li>
 * </ul>
 */
SCanvas::SCanvas(void)
{
  isCacheOn = true;
}

SCanvas::~SCanvas ()
{
}

/**
 * Try to put a cached image with id at x,y 
 * if failed, return false. You should draw it then.
 * even if this return true, fill should be called to 
 * actually place the cached image.
 */
bool
SCanvas::newpath (double x, double y, const SString& id)
{
  return false;
}

/**
 * Fill the image with this pen.
 */
void
SCanvas::fill (const SPen& pen)
{
}

/**
 * Stroke the image with this pen.
 */
void
SCanvas::stroke(const SPen& pen)
{
}

void
SCanvas::moveto (double x, double y)
{
}

void
SCanvas::lineto (double x, double y)
{
}

void
SCanvas::curveto (double x0, double y0, double x1, double y1, double x2, double y2)
{
}

void
SCanvas::closepath()
{
}

void
SCanvas::rotate (double angle)
{
}

void
SCanvas::scale (double x, double y)
{
}

void
SCanvas::translate (double x, double y)
{
}


/**
 * put an image to the scene. originX and OriginY is ignored.
 * @param x is the x corener of the image.
 * @param y is the y corner of the image.
 * @param image is the actual image.
 */
void 
SCanvas::putImage (int x, int y, const SImage& image)
{
}

void
SCanvas::setBackground(const SColor &color)
{
}

void
SCanvas::pushmatrix()
{
}

void
SCanvas::popmatrix()
{
}

/**
 * Draw a native font to the screen. This will not delete existing data. 
 * @param x is the origo position 
 * @param y is the origo position 
 * @param native is X11 FID for X11
 * @param data is a XChar2b structure for X11
 * @param len is the unber of chars for X11
 */
void
SCanvas::bitfont (const SPen& pen, double x, double y, void* native, char* data, unsigned int len)
{
}

/**
 * Fill a solid rectangle
 * @param x is the upper left corner
 * @param y is the upper top corner
 * @param width is the width of the region to fill
 * @param height is the height of the region to fill
 */
void
SCanvas::bitfill (const SColor& bg, int x, int y, 
 unsigned int width, unsigned int height)
{
}

/**
 * Draw a solid line.
 * @param x is the starting x point
 * @param y is the starting y point
 * @param x is the ending non-exclusive  x point
 * @param y is the ending non-exclusive  y point
 */
void
SCanvas::bitline (const SColor& fg, int x, int y, int tox, int toy)
{
}

/**
 * Draw a solid line.
 * @param x is the x point
 * @param y is the y point
 */
void
SCanvas::bitpoint (const SColor& fg, int x, int y)
{
}

void
SCanvas::bitpoints (const SColor& fg, const int* x, const int* y, 
         unsigned int size)
{
}

/**
 * This routine is not supposed to be used extensively. This is
 * to check the current matrix.
 */
SS_Matrix2D
SCanvas::getCurrentMatrix() const
{
  return SS_Matrix2D();
}

/**
 * turn on cacheing.
 */
bool 
SCanvas::cacheOn(bool on)
{
  bool old = isCacheOn;
  isCacheOn = on;
  return old;
}
