--[[-------------------------------------------------------------------
Targus IR Keyboard

9600 baud, 8N1

Key down sends one byte:  KEY
Key up sends one byte:    KEY | 0x80

Targus - http://www.ipaqabilities.com/images/reviews/targus/IM0341.jpg

-----------

Copyright (c) 2005, David J. Kessler <dkessler@kopsisengineering.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-------------------------------------------------------------------]]--

-- Basic information about this driver
description = "Targus IR Keyboard Driver"
version = "0.2"

-- Modifier key information
scancode_fn = 0x61
scancode_punc = 0
scancode_num = 0
scancode_shiftl = 0x2A
scancode_shiftr = 0x36
scancode_caps = 0x3A
has_num_lock = 0
has_punc_lock = 0
has_fn_lock = 0

-- Scancode maps
map_normal = {
	   ZK_ESCAPE, ZK_1, ZK_2, ZK_3, ZK_4, ZK_5, ZK_6,
	ZK_7, ZK_8, ZK_9, ZK_0, ZK_MINUS, ZK_EQUAL, ZK_BACKSPACE, ZK_TAB,
	ZK_Q, ZK_W, ZK_E, ZK_R, ZK_T, ZK_Y, ZK_U, ZK_I,
	ZK_O, ZK_P, ZK_BRACELEFT, ZK_BRACERIGHT, ZK_RETURN, ZK_CONTROLL, ZK_A, ZK_S,
	ZK_D, ZK_F, ZK_G, ZK_H, ZK_J, ZK_K, ZK_L, ZK_SEMICOLON,
	ZK_APOSTROPHE, ZK_GRAVE, ZK_SHIFT, ZK_BACKSLASH, ZK_Z, ZK_X, ZK_C, ZK_V,
	ZK_B, ZK_N, ZK_M, ZK_COMMA, ZK_PERIOD, ZK_SLASH, 0, ZK_SHIFT,
	ZK_ALTL, ZK_SPACE, 0, ZK_ACTIVITY, ZK_F5, ZK_F6, ZK_F7, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	ZK_UP, 0, 0, ZK_LEFT, 0, ZK_RIGHT, 0, 0,
	ZK_DOWN, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, ZK_SPACE, 0, 0, ZK_DELETE, 0,
	ZK_OK, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_shift = {
	   ZK_ESCAPE, ZK_EXCLAIM, ZK_AT, ZK_NUMBERSIGN, ZK_DOLLAR, ZK_PERCENT, 0,
	ZK_AMPERSAND, ZK_ASTERISK, ZK_PARENLEFT, ZK_PARENRIGHT, ZK_UNDERSCORE, ZK_PLUS, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, ZK_BRACKETLEFT, ZK_BRACKETRIGHT, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, ZK_COLON,
	ZK_QUOTEDBL, ZK_TILDE, 0, ZK_BAR, 0, 0, 0, 0,
	0, 0, 0, ZK_LESS, ZK_GREATER, ZK_QUESTION, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_fn = {
	   0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, ZK_POWER, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, ZK_OK, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0}

map_punc = {0}

map_num = {0}

-- Function to convert a byte received from the kb to a scancode
function do_scancode ( s )
	key = 0;
	key_down = 0;

	key = s & 0x7f;
	if (s & 0x80 == 0x80) then
		key_down = 0
	else
		key_down = 1
	end

	return key, key_down
end
