		.TEXT
		.ALIGN	4

;;;;;
		.GLOBAL LINUX_DBG_MSG
		.type	LINUX_DBG_MSG, %function
LINUX_DBG_MSG:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL ResetFPGAW100
		.type	ResetFPGAW100, %function
ResetFPGAW100:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL START_FPGA
		.type	START_FPGA, %function
START_FPGA:
		MOV	R12, SP
		STMFD	SP!, {R4,R5,R11,R12,LR,PC}
		LDR	R5, =Dev_Handle
		SUB	R11, R12, #4
		LDR	R3, [R5]
		AND	R4, R0,	#0xFF
		CMP	R3, #0
		BEQ	.loc_34CEE0
		BL	END_FPGA

.loc_34CEE0:
		LDR	R0, =aDevFb0
		MOV	R1, #2
		BL	open
		CMP	R4, #0
		STR	R0, [R5]
		BEQ	.loc_34CEFC
		BL	ResetFPGAW100

.loc_34CEFC:
		LDR	R0, [R5]
		MOV	R1, #1
		BL	MapBar
		LDR	R3, =sDrvState
		STR	R0, [R3]
		LDMDB	R11, {R4,R5,R11,SP,PC}

;;;;;
		.GLOBAL END_FPGA
		.type	END_FPGA, %function
END_FPGA:
		MOV	R12, SP
		STMFD	SP!, {R4-R6,R11,R12,LR,PC}
		LDR	R6, =sDrvState
		LDR	R3, [R6]
		SUB	R11, R12, #4
		LDR	R5, =Dev_Handle
		CMP	R3, #0
		BEQ	.loc_34CF4C
		LDR	R0, [R5]
		MOV	R1, #1
		BL	UnMapBar

.loc_34CF4C:
		MOV	R4, #0
		STR	R4, [R6]
		LDR	R0, [R5]
		BL	close
		STR	R4, [R5]
		LDMDB	R11, {R4-R6,R11,SP,PC}

;;;;;
		.GLOBAL FPGA_MEM_RD8
		.type	FPGA_MEM_RD8, %function
FPGA_MEM_RD8:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDR	R3, =sDrvState
		SUB	SP, SP,	#0x14
		LDR	R1, [R3]
		MOV	R12, R0
		CMP	R1, #0
		BNE	.loc_34CFC8
		SUB	R3, R11, #0x14
		STR	R3, [SP]
		SUB	R2, R11, #0xD
		STR	R2, [SP,#4]
		LDR	R3, =Dev_Handle

.loc_34CFA4:
		LDR	R0, [R3]
		MOV	R2, R12
		STR	R1, [SP,#8]
		MOV	R1, #1
		MOV	R3, R1
		BL	QL_BAR_Read
		B	.loc_34CFD0
.loc_34CFC8:
		LDRB	R3, [R1,R12]
		STRB	R3, [R11,#-0xD]

.loc_34CFD0:
		LDRB	R0, [R11,#-0xD]
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL FPGA_MEM_RD32
		.type	FPGA_MEM_RD32, %function
FPGA_MEM_RD32:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDR	R3, =sDrvState
		SUB	SP, SP,	#0x14
		LDR	R1, [R3]
		MOV	R12, R0
		CMP	R1, #0
		BNE	.loc_34D038
		SUB	R3, R11, #0x10
		STR	R3, [SP]
		SUB	R2, R11, #0x14
		STR	R2, [SP,#4]
		LDR	R3, =Dev_Handle
		LDR	R0, [R3]
		MOV	R2, R12
		STR	R1, [SP,#8]
		MOV	R1, #1
		MOV	R3, #4
		BL	QL_BAR_Read
		LDR	R0, [R11,#-0x14]
		B	.loc_34D048
.loc_34D038:
		MOV	R3, R12,LSR#2
		LDR	R2, [R1,R3,LSL#2]
		MOV	R0, R2
		STR	R2, [R11,#-0x14]

.loc_34D048:
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL FPGA_MEM_WR8
		.type	FPGA_MEM_WR8, %function
FPGA_MEM_WR8:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		AND	R1, R1,	#0xFF
		LDR	R3, =sDrvState
		SUB	SP, SP,	#0x14
		STRB	R1, [R11,#-0xD]
		LDR	R12, [R3]
		MOV	LR, R0
		CMP	R12, #0
		BEQ	.loc_34D084
		STRB	R1, [R12,LR]
		B	.loc_34D0B8
.loc_34D084:
		SUB	R3, R11, #0x14
		STR	R3, [SP]
		SUB	R2, R11, #0xD
		STR	R2, [SP,#4]
		MOV	R1, #1
		LDR	R3, =Dev_Handle
		MOV	R2, LR
		LDR	R0, [R3]
		MOV	R3, R1
		STR	R12, [SP,#8]
		BL	QL_BAR_Write
		B	.loc_34D0B8
.loc_34D0B8:
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL FPGA_MEM_WR32
		.type	FPGA_MEM_WR32, %function
FPGA_MEM_WR32:
		MOV	R12, SP
		STMFD	SP!, {R4,R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDR	R3, =sDrvState
		SUB	SP, SP,	#0x14
		STR	R1, [R11,#-0x18]
		MOV	R4, #4
		STR	R4, [R11,#-0x14]
		LDR	R12, [R3]
		MOV	LR, R0
		CMP	R12, #0
		BEQ	.loc_34D0FC
		MOV	R3, LR,LSR#2
		STR	R1, [R12,R3,LSL#2]
		B	.loc_34D130
.loc_34D0FC:
		SUB	R3, R11, #0x14
		STR	R3, [SP]
		SUB	R2, R11, #0x18
		STR	R2, [SP,#4]
		MOV	R1, #1
		LDR	R3, =Dev_Handle
		MOV	R2, LR
		LDR	R0, [R3]
		MOV	R3, R4
		STR	R12, [SP,#8]
		BL	QL_BAR_Write
		B	.loc_34D130
.loc_34D130:
		LDMDB	R11, {R4,R11,SP,PC}

;;;;;
		.GLOBAL FPGA_CFG_RD8
		.type	FPGA_CFG_RD8, %function
FPGA_CFG_RD8:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		LDR	R3, =lpgDrvState
		LDR	R2, [R3]
		SUB	R11, R12, #4
		LDR	R1, [R2,#0x14]
		MOV	R3, R0,LSL#16
		CMP	R1, #0
		MOVNE	R0, R3
		BL	FPGA_MEM_RD8
		AND	R0, R0,	#0xFF
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL FPGA_CFG_WR8
		.type	FPGA_CFG_WR8, %function
FPGA_CFG_WR8:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		LDR	R3, =lpgDrvState
		SUB	R11, R12, #4
		LDR	R2, [R3]
		AND	R1, R1,	#0xFF
		LDR	R12, [R2,#0x14]
		MOV	R3, R0,LSL#16
		CMP	R12, #0
		MOVNE	R0, R3
		BL	FPGA_MEM_WR8
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL QL_BAR_Read
		.type	QL_BAR_Read, %function
QL_BAR_Read:
		MOV	R12, SP
		STMFD	SP!, {R4,R11,R12,LR,PC}
		SUB	R11, R12, #4
		MOV	R4, #0
		LDR	R1, =aErrSomeoneCall
		SUB	SP, SP,	#0x10
		LDR	R3, [R11,#4]
		MOV	R0, R4
		STR	R4, [R3]
		BL	LINUX_DBG_MSG
		MOV	R0, R4
		B	.loc_34D1D0
.loc_34D1D0:
		LDMDB	R11, {R4,R11,SP,PC}

;;;;;
		.GLOBAL QL_BAR_Write
		.type	QL_BAR_Write, %function
QL_BAR_Write:
		MOV	R12, SP
		STMFD	SP!, {R4,R11,R12,LR,PC}
		SUB	R11, R12, #4
		LDR	R3, [R11,#4]
		MOV	R4, #0
		LDR	R1, =aErrSomeoneCa_0
		MOV	R0, R4
		STR	R4, [R3]
		BL	LINUX_DBG_MSG
		MOV	R0, R4
		LDMDB	R11, {R4,R11,SP,PC}

;;;;;
		.GLOBAL MapBar
		.type	MapBar, %function
MapBar:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		MOV	R0, #0xF1000000
		LDR	R3, =unk_41948C
		SUB	SP, SP,	#0x44
		STR	R0, [R3]
		B	.loc_34D228
.loc_34D228:
		LDMDB	R11, {R11,SP,PC}

;;;;;
		.GLOBAL UnMapBar
		.type	UnMapBar, %function
UnMapBar:
		MOV	R12, SP
		STMFD	SP!, {R11,R12,LR,PC}
		SUB	R11, R12, #4
		MOV	R0, #1
		LDMDB	R11, {R11,SP,PC}
