/***************************************************************************
 *                       FileDialog.cpp  -  description
 *                               -------------------
 *  begin                : Tue Sep 10 10:40:21 BST 2002
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "FileDialog.h"
#include <qaction.h>
#include <qfile.h>
#include <qdialog.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qdir.h>
#ifndef __FOR_QT__
#include <qpe/resource.h>
#endif

GetFileName::GetFileName(QWidget *parent, const char *name)
    : QWidget(parent, name)
{
    filename = "";
    folderpath = ".";
    showHidden = false;
    boxAll = new QVBox(this);
    QHBox * lineEditBox = new QHBox(boxAll);
    QHBox * listViewBox = new QHBox(boxAll);
    filepath = new QLineEdit(lineEditBox);
    cdButton = new QPushButton(lineEditBox);
    hiddenCheckBox = new QCheckBox("Show hidden",lineEditBox);
#ifndef __FOR_QT__
    cdButton->setPixmap(Resource::loadPixmap("OKButton"));
#else 
    QPixmap p;
    p.load("/usr/share/pixmaps/justreader/button_ok.png");
    cdButton->setPixmap(p);
#endif
    listview = new QListView(listViewBox);
    listview->addColumn("Name",0);
    listview->addColumn("Type",0);
    listview->addColumn("Size",0);
    listview->setSorting(-1);
    listview->setColumnWidth(1,30);
    listview->setColumnWidth(2,50);
    //setFolderList("/home/dima");
    // 2002-09-13, Psimon Ghim, Single-click is more convenient.
//    connect( listview, SIGNAL( doubleClicked( QListViewItem * ) ),
    connect( listview, SIGNAL( clicked( QListViewItem * ) ),
             this, SLOT( slotFolderSelected( QListViewItem * ) ) );
    connect( listview, SIGNAL( returnPressed( QListViewItem * ) ),
	     this, SLOT( slotFolderSelected( QListViewItem * ) ) );
    connect( cdButton, SIGNAL(clicked()), this, SLOT(cdTo()));
    connect( filepath, SIGNAL(returnPressed()),this, SLOT(cdTo()));
    connect( hiddenCheckBox, SIGNAL(clicked()),this, SLOT(toggleHidden()));
}

void GetFileName::toggleHidden()
{
    showHidden = hiddenCheckBox->isChecked();
    setFolderList(folderpath);
}

void GetFileName::cdTo()
{
    setFolderList(filepath->text());
}

void GetFileName::keyPressEvent(QKeyEvent * e)
{
    switch (e->key())
    {
	case Key_F33:
	    if (listview->currentItem())
	    {
		slotFolderSelected(listview->currentItem());
	    }
	    break;
	case Key_Escape:
	    emit fileNotSelectedSignal();
	    break;
	default:
	    e->ignore();
   }
}



void GetFileName::resizeEvent(QResizeEvent *)
{
    QScrollBar *scrollbar = listview->verticalScrollBar();
    boxAll->resize(size());
    int scrollbarwidth;
    if (scrollbar->isVisible()) scrollbarwidth = scrollbar->width();
    else scrollbarwidth = 0;
    listview->setColumnWidth(0,width()-listview->columnWidth(1)-listview->columnWidth(2)-scrollbarwidth-4);
}

void GetFileName::showEvent(QShowEvent *)
{
//    filepath->setFont(QFont::QFont(fontName,10,QFont::Normal,FALSE));
    QScrollBar *scrollbar = listview->verticalScrollBar();
    int scrollbarwidth;
    //listview->setFont(QFont::QFont("helvetica",10,QFont::Normal,FALSE));
//    listview->setFont(QFont::QFont(fontName,10,QFont::Normal,FALSE));
    if (scrollbar->isVisible()) scrollbarwidth = scrollbar->width();
    else scrollbarwidth = 0;
    listview->setColumnWidth(0,width()-listview->columnWidth(1)-listview->columnWidth(2)-scrollbarwidth-4);
}
                                      
void GetFileName::setFolderList(QString folder)
{
    QDir dir;
    QListViewItem *after = 0L;
    QListViewItem *child = 0L;

    listview->clear();
    if (showHidden) dir.setFilter(QDir::All|QDir::Hidden);
    dir.setPath(folder);
    if (!dir.exists()) dir.setPath(dir.homeDirPath());
    filepath->setText(dir.absPath());
    currentPath = dir.absPath();
    dir.setSorting(QDir::Name|QDir::DirsFirst|QDir::IgnoreCase);
    const QFileInfoList * filelist = dir.entryInfoList();
    QFileInfoListIterator it(*filelist);
    QFileInfo * fi;
    while( (fi=it.current()) != 0 )
    {
	++it;
	if ( fi->fileName() == ".")
	    ;
	else if ( fi->fileName() == "..")
	{
	    child = new QListViewItem(listview,after,fi->fileName(),"dir","");   
	} else if ( fi->fileName() == "NotAvailable")
	{
	    child = new QListViewItem(listview,after,"..","dir","");
	}
	else if ( fi->isDir())
	{
	    child = new QListViewItem(listview,after,fi->fileName(),"dir","");
	}
	//else if (fi->isSymLink())
	//    ;
	else
	{
	    //QListViewItem * after = listview->currentItem();
	     child = new QListViewItem(listview,after,fi->fileName(),"",QString("%1").arg(fi->size()));
	}
	after = child; 
    }
    QScrollBar *scrollbar = listview->verticalScrollBar();
    int scrollbarwidth;
    if (scrollbar->isVisible()) scrollbarwidth = scrollbar->width();
    else scrollbarwidth = 0;
    listview->setColumnWidth(0,width()-listview->columnWidth(1)-listview->columnWidth(2)-scrollbarwidth-4);

}

void GetFileName::slotFolderSelected(QListViewItem *item)
{
    QDir dir;
    dir.setPath(currentPath);
    if (!dir.exists()) dir.setPath(dir.homeDirPath());
    // 2002-09-13, Psimon Ghim, Avoid null-pointer access.
    if ( item == 0 ) return;
    if (item->text(1) == "dir")
    {
	if (item->text(0) == "..")
	{
	    dir.cdUp();
	}
	else
	{
	    dir.cd(item->text(0));
	}
	setFolderList(dir.absPath());
    }
    else
    {
	filename = dir.absPath()+"/"+item->text(0);
	emit fileSelectedSignal();
    }
    folderpath = dir.absPath();
}

