.\" $XFree86: xc/doc/man/DMX/DMXGetScreenAttributes.man,v 1.1 2004/06/30 20:21:36 martin Exp $
.\"
.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXGetScreenAttributes 3X __vendorversion__
.SH NAME
DMXGetScreenAttributes \- determine back-end screen attributes
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXGetScreenAttributes(Display " *dpy ,
.BI "                            int " screen ,
.BI "                            DMXScreenAttributes " *attr );
.fi
.SH DESCRIPTION
.B DMXGetScreenAttributes()
returns the attributes for the single DMX screen specified in
.IR screen .
.PP
The
.I DMXScreenAttributes
structure is:
.sp
.nf
typedef struct {
    char         *displayName;
    int          logicalScreen;

    unsigned int screenWindowWidth;
    unsigned int screenWindowHeight;
    int          screenWindowXoffset;
    int          screenWindowYoffset;

    unsigned int rootWindowWidth;
    unsigned int rootWindowHeight;
    int          rootWindowXoffset;
    int          rootWindowYoffset;

    int          rootWindowXorigin;
    int          rootWindowYorigin;
} DMXScreenAttributes;
.fi
.PP
.I displayName
is the name used to open the display, either from the
.BR Xdmx (1)
command-line or from the configuration file.
.PP
.I logicalScreen
is the value of the screen that that
.BR Xdmx (1)
server exports to clients.  When Xinerama is in use, this value is
typically 0 for all values of physicalScreen.  If Xinerama is in
use,
.I rootWindowXorigin
and
.I rootWindowYorigin
specify where the physical screen is positioned in the global Xinerama
coordinate system.  Otherwise, these values are set to 0.
.PP
.IR screenWindowWidth ", " screenWindowHeight ", "
.IR screenWindowXoffset ", and " screenWindowYoffset
are a geometry specification (see
.BR X (7x))
for the location of the DMX screen on the back-end screen.  The
coordinant system of the back-end display is used for these values.
.PP
.IR rootWindowWidth ", " rootWindowHeight ", "
.IR rootWindowXoffset ", and " rootWindowYoffset
are a geometry specification (see
.BR X (7x))
for the location of the root window on the screen window.  The
coordinant system of the screen window is used.  In most cases, the root
window will have the same geometry as the DMX screen window, and will
occupy the same area of the back-end display.  (This would not be the
case, for example, if automatic projector alignment is used.)
.SH "RETURN VALUE"
.B DMXGetScreenAttributes()
returns
.B True
unless there is a protocol error.
.PP
.B DMXGetScreenAttributes()
can generate
.B BadValue
errors.
.SH "SEE ALSO"
.BR DMXGetScreenCount "(3X), "
.BR DMXChangeScreenAttributes "(3X), "
.BR DMX "(3X), " Xdmx (1)
