.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/AllPlanes.man,v 1.4 2005/02/11 03:02:54 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AllPlanes 3X11 __vendorversion__ "XLIB FUNCTIONS"
.SH NAME
AllPlanes, BlackPixel, WhitePixel, ConnectionNumber, DefaultColormap, DefaultDepth, XListDepths, DefaultGC, DefaultRootWindow, DefaultScreenOfDisplay, DefaultScreen, DefaultVisual, DisplayCells, DisplayPlanes, DisplayString, XMaxRequestSize, XExtendedMaxRequestSize, LastKnownRequestProcessed, NextRequest, ProtocolVersion, ProtocolRevision, QLength, RootWindow, ScreenCount, ScreenOfDisplay, ServerVendor, VendorRelease \- Display macros and functions
.SH SYNTAX
unsigned long AllPlanes; 
.HP
unsigned long BlackPixel\^(\^Display *\fIdisplay\fP\^, int \^\fIscreen_number\fP\^);
.HP
unsigned long WhitePixel\^(\^Display *\fIdisplay\fP\^, int \^\fIscreen_number\fP\^); 
.HP
int ConnectionNumber\^(\^Display *\fIdisplay\fP\^); 
.HP
Colormap DefaultColormap\^(\^Display *\fIdisplay\fP\^,
\^int \fIscreen_number\fP\^); 
.HP
int DefaultDepth\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^); 
.HP
int *XListDepths\^(\^Display *\fIdisplay\fP, int \fIscreen_number\fP, int
\fIcount_return\fP\^); 
.HP
GC DefaultGC\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^); 
.HP
Window DefaultRootWindow\^(\^Display *\fIdisplay\fP\^); 
.HP
Screen *DefaultScreenOfDisplay\^(\^Display *\fIdisplay\fP\^); 
.HP
int DefaultScreen\^(\^Display *\fIdisplay\fP\^); 
.HP
Visual *DefaultVisual\^(\^Display *\fIdisplay\fP\^, \^int
\fIscreen_number\fP\^); 
.HP
int DisplayCells\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^); 
.HP
int DisplayPlanes\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^);
.HP
char *DisplayString\^(\^Display *\fIdisplay\fP\^);
.HP
long XMaxRequestSize(\^Display *\fIdisplay\fP\^)
.HP
long XExtendedMaxRequestSize(\^Display *\fIdisplay\fP\^)
.HP
unsigned long LastKnownRequestProcessed\^(\^Display *\fIdisplay\fP\^); 
.HP
unsigned long NextRequest\^(\^Display *\fIdisplay\fP\^); 
.HP
int ProtocolVersion\^(\^Display *\fIdisplay\fP\^); 
.HP
int ProtocolRevision\^(\^Display *\fIdisplay\fP\^); 
.HP
int QLength\^(\^Display *\fIdisplay\fP\^); 
.HP
Window RootWindow\^(\^Display *\fIdisplay\fP\^, \^int \fIscreen_number\fP\^); 
.HP
int ScreenCount\^(\^Display *\fIdisplay\fP\^); 
.HP
Screen *ScreenOfDisplay\^(\^Display *\fIdisplay\fP, int
\fIscreen_number\fP\^); 
.HP
char *ServerVendor\^(\^Display *\fIdisplay\fP\^)
.HP
int VendorRelease\^(\^Display *\fIdisplay\fP\^)
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIscreen_number\fP 1i
Specifies the appropriate screen number on the host server.
.ds Cn depths
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.SH DESCRIPTION
The
.ZN AllPlanes
macro returns a value with all bits set to 1 suitable for use in a plane 
argument to a procedure.
.LP
The
.ZN BlackPixel
macro returns the black pixel value for the specified screen.
.LP
The
.ZN WhitePixel
macro returns the white pixel value for the specified screen.
.LP
The
.ZN ConnectionNumber
macro returns a connection number for the specified display.
.LP
The
.ZN DefaultColormap
macro returns the default colormap ID for allocation on the specified screen.
.LP
The
.ZN DefaultDepth
macro returns the depth (number of planes) of the default root window for the
specified screen.
.LP
The
.ZN XListDepths
function returns the array of depths 
that are available on the specified screen.
If the specified screen_number is valid and sufficient memory for the array
can be allocated,
.ZN XListDepths
sets count_return to the number of available depths.
Otherwise, it does not set count_return and returns NULL.
To release the memory allocated for the array of depths, use
.ZN XFree .
.LP
The
.ZN DefaultGC
macro returns the default GC for the root window of the
specified screen.
.LP
The
.ZN DefaultRootWindow
macro returns the root window for the default screen.
.LP
The
.ZN DefaultScreenOfDisplay
macro returns the default screen of the specified display.
.LP
The
.ZN DefaultScreen
macro returns the default screen number referenced in the
.ZN XOpenDisplay
routine.
.LP
The
.ZN DefaultVisual
macro returns the default visual type for the specified screen.
.LP
The
.ZN DisplayCells
macro returns the number of entries in the default colormap.
.LP
The
.ZN DisplayPlanes
macro returns the depth of the root window of the specified screen.
.LP
The
.ZN DisplayString
macro returns the string that was passed to
.ZN XOpenDisplay
when the current display was opened.
.LP
The
.ZN XMaxRequestSize
function returns the maximum request size (in 4-byte units) supported
by the server without using an extended-length protocol encoding.
Single protocol requests to the server can be no larger than this size
unless an extended-length protocol encoding is supported by the server.
The protocol guarantees the size to be no smaller than 4096 units
(16384 bytes).
Xlib automatically breaks data up into multiple protocol requests
as necessary for the following functions:
.ZN XDrawPoints ,
.ZN XDrawRectangles ,
.ZN XDrawSegments ,
.ZN XFillArcs ,
.ZN XFillRectangles ,
and 
.ZN XPutImage .
.LP
The
.ZN XExtendedMaxRequestSize
function returns zero if the specified display does not support an
extended-length protocol encoding; otherwise,
it returns the maximum request size (in 4-byte units) supported
by the server using the extended-length encoding.
The Xlib functions
.ZN XDrawLines ,
.ZN XDrawArcs ,
.ZN XFillPolygon ,
.ZN XChangeProperty ,
.ZN XSetClipRectangles ,
and
.ZN XSetRegion
will use the extended-length encoding as necessary, if supported
by the server.  Use of the extended-length encoding in other Xlib
functions (for example,
.ZN XDrawPoints ,
.ZN XDrawRectangles ,
.ZN XDrawSegments ,
.ZN XFillArcs ,
.ZN XFillRectangles ,
.ZN XPutImage )
is permitted but not required; an Xlib implementation may choose to
split the data across multiple smaller requests instead.
.LP
The
.ZN LastKnownRequestProcessed
macro extracts the full serial number of the last request known by Xlib
to have been processed by the X server.
.LP
The
.ZN NextRequest
macro extracts the full serial number that is to be used for the next request.
.LP
The
.ZN ProtocolVersion
macro returns the major version number (11) of the X protocol associated with
the connected display.
.LP
The
.ZN ProtocolRevision
macro returns the minor protocol revision number of the X server.
.LP
The
.ZN QLength
macro returns the length of the event queue for the connected display.
.LP
The
.ZN RootWindow
macro returns the root window.
.LP
The
.ZN ScreenCount
macro returns the number of available screens.
.LP
The
.ZN ScreenOfDisplay
macro returns a pointer to the screen of the specified display.
.LP
The
.ZN ServerVendor
macro returns a pointer to a null-terminated string that provides
some identification of the owner of the X server implementation.
.LP
The
.ZN VendorRelease
macro returns a number related to a vendor's release of the X server.
.SH "SEE ALSO"
BlackPixelOfScreen(3X11),
ImageByteOrder(3X11),
IsCursorKey(3X11),
XOpenDisplay(3X11)
.br
\fI\*(xL\fP
