/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OD_POSTPONE_LISTENERSTATE_H_
#define _OD_POSTPONE_LISTENERSTATE_H_

// Internal includes
#include "OD_ListenerState.h"
#include "OD_XMLRecorder.h"


/**
 * It stores the XML data and, when wanted, does its parsing.
 * 
 * This class was created due to a issue with headers/footers parsing. They are
 * defined on the styles stream but their corresponding AbiWord sections can only
 * be added after the definition of all styles, page size and (I think) the
 * sections of the text content.
 */
class OD_Postpone_ListenerState : public OD_ListenerState {
    
public:
    OD_Postpone_ListenerState(OD_ListenerState* pParserState,
                              bool bDeleteWhenPop,
    						  OD_ElementStack& rElementStack);
    
    virtual ~OD_Postpone_ListenerState();
    
    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                       OD_ListenerStateAction& rAction);
                               
    void endElement (const XML_Char* pName, OD_ListenerStateAction& rAction);
                             
    void charData (const XML_Char* pBuffer, int length);
    
    OD_ListenerState* getParserState() {return m_pParserState;}
    bool getDeleteParserStateWhenPop() const {return m_bDeleteParserStateWhenPop;}
    const OD_XMLRecorder* getXMLRecorder() const {return &m_xmlRecorder;}
    
private:

    OD_XMLRecorder m_xmlRecorder;
    
    OD_ListenerState* m_pParserState;
    bool m_bDeleteParserStateWhenPop;

    // Auxiliary variable to make us know when we reached the corresponding
    // end element tag of a given element.
    UT_uint32 m_elementStackCount;
};

#endif //_OD_POSTPONE_LISTENERSTATE_H_
