/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OO_WRITERIMPL_H_
#define _OO_WRITERIMPL_H_

// Internal includes
#include "OO_ListenerImpl.h"
#include "OO_StylesContainer.h"

// External includes
#include <gsf/gsf.h>


/**
 * OO_WriterImpl: This class writes out the content which reference the style
 * definitions which we collected earlier with the accumulator.
 */
class OO_WriterImpl : public OO_ListenerImpl
{
public:
    OO_WriterImpl(GsfOutfile* pOutfile, OO_StylesContainer* pStylesContainer);
    ~OO_WriterImpl();
    
    virtual void insertText(const UT_UCSChar * data, UT_uint32 length);
    
    virtual void openBlock(UT_String & styleAtts, UT_String & styleProps,
        UT_String & font, bool bIsHeading = false);
        
    virtual void closeBlock();
    virtual void openSpan(UT_String & props, UT_String & font);
    virtual void closeSpan();

private:

    void _writeString (GsfOutput * output, const UT_String & str);
    
    void _outputCharData (GsfOutput * output, const UT_UCSChar * data,
        UT_uint32 length);

    GsfOutput * m_pContentStream;
    OO_StylesContainer *m_pStylesContainer;
    UT_UTF8String m_blockEnd;
};


#endif //_OO_WRITERIMPL_H_
