#ifndef CAMTILE_HPP
#define CAMTILE_HPP

#include <qglobal.h>

struct CCamTile
{
public:
   int x, y;			/** Location */
   int in_offsets[8][8];	/** offsets within input image buffer */
   int out_offsets[8][8];	/** offsets within output image buffer */
   
   int abs_value, nb_value;
   int PCount;  // P-frame count
   
   CCamTile *Left, *Top, *Right, *Bottom; /** Neighbours */
   CCamTile *NextZag;		/** For zig-zag scanning */
   CCamTile *pUsedPrev, *pUsedNext;

   void CalculateForward(uchar *dst, uchar *src);
   void CalculateInverse(uchar *dst, uchar *src);

   void CalcDiffValue(const uchar *src);
   void CopyTile(uchar *dst, const uchar *src);
   void ClearInTile(uchar *dst);
   void ClearOutTile(uchar *dst);
   
   static int CompareTile(const void *t1, const void *t2);
};

#endif
