
#include <assert.h>

#include "ImagePanelRGB.h"

/**
  \class CImagePanelRGB
  \brief A simple CamPanel that displays RGB images from \ref CVideoDevice

  This class is placed right on top of CVideoDevice: it handles the RGB
  image. See also \ref CImagePanelYUV

  Registers panel "image.rgb"
 */
 

/**
  \param video A \ref CVideoDevice class.
  \param parent The QWdiget parent object
  \param name The widget name
  \brief Constructor.
 */
CImagePanelRGB::CImagePanelRGB(CVideoDevice *video, QWidget *parent, const char *name)
	: CCamPanel("image.rgb", "Video image RGB", RGB, TRUE, parent, name)
{
   assert(video != NULL);
   pVideo = video;
   SetSize(pVideo->GetSize());
   connect(pVideo, SIGNAL(Resized(const QSize &)), this, SLOT(SetSize(const QSize &)));
   connect(pVideo, SIGNAL(Notify()), this, SLOT(UpdateImage()));
}

// private

void CImagePanelRGB::UpdateImage()
{
   ImgRGB = *pVideo->GetRGB();
   update();
}


// public

/// overloaded

void CImagePanelRGB::hideEvent(QHideEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelRGB::hideEvent()");
#endif   
   pVideo->EnableRGB(FALSE);
   QWidget::hideEvent(e);
}

void CImagePanelRGB::showEvent(QShowEvent *e)
{
#if TRACE_PANELSIGNALS
   qDebug("CImagePanelRGB::showEvent()");
#endif   
   pVideo->EnableRGB(TRUE);
   QWidget::showEvent(e);
}



#if 0  
/** 
  \fn void CImagePanelRGB::UpdatePanel()
  \brief Retrieve RGB image from CVideoDevice.
  
  This function will update the internal RGB representation of the image
  and emit an Updated() signal.
 */  
void CImagePanelRGB::UpdatePanel()
{
   if (IsVisible() || IsUsed()) {
     ImgRGB = *pVideo->GetRGB();
     emit Updated();
   }
}
#endif
