#ident "@(#)rules.sps	1.10 05/08/06 "
###########################################################################
# Written 2005 by J. Schilling
###########################################################################
#
# Rules for wrapping around other make systems
#
###########################################################################
# Copyright Jrg Schilling. All rights reserved.
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License, Version 1.0 only.
# See the file CDDL.Schily.txt in this distribution or
# http://opensource.org/licenses/cddl1.php for details.
###########################################################################
PTARGET=	$(TARGET)
SRCFILE=	$(TARGET)
###########################################################################

_INSMODEI=	$(_UNIQ)$(INSMODE)
__INSMODEI=	$(_INSMODEI:$(_UNIQ)=$(INSMODEF))
INSMODEI=	$(__INSMODEI:$(_UNIQ)%=%)

#all:		$(SRCFILE)

###########################################################################
include		$(SRCROOT)/$(RULESDIR)/rules.clr
#include		$(SRCROOT)/$(RULESDIR)/rules.ins
include		$(SRCROOT)/$(RULESDIR)/rules.tag
include		$(SRCROOT)/$(RULESDIR)/rules.hlp
include		$(SRCROOT)/$(RULESDIR)/dummy.dep
include		$(SRCROOT)/$(RULESDIR)/rules.tpk
###########################################################################

all: $(ARCHDIR)/config.status $(POSTCONFIG)
	cd $(ARCHDIR)/; $(MAKE) $(MAKEMACS) $(MAKEOPTS) $@

install: all
	cd $(ARCHDIR)/; DESTDIR=$(DEST_DIR) $(MAKE) $(MAKEMACS) $(MAKEOPTS) DESTDIR=$(DEST_DIR) $@

#
# Hack until the <mach>-<os>-*cc.rul files are updated
#
_HCCCOM=	$(OARCH:%-gcc=gcc)
HCCCOM=		$(_HCCCOM:%-cc=cc)

_CCCOM=		$(_UNIQ)$(CCCOM)
__CCCOM=	$(_CCCOM:$(_UNIQ)=$(HCCCOM))
XCCCOM=		$(__CCCOM:$(_UNIQ)%=%)

_CONF_SCRIPT=	$(_UNIQ)$(CONF_SCRIPT)
__CONF_SCRIPT=	$(_CONF_SCRIPT:$(_UNIQ)=configure)
CONFSCRIPT=	$(__CONF_SCRIPT:$(_UNIQ)%=%)

#
# Note: $(___CONF_SCR:$(_UNIQ)=:) is not accepted by Sun make
# because of a parser bug. We thus use "true".
#
COLON=:
_CONF_SCR=	$(CONFSCRIPT:none=)
__CONF_SCR=	$(_CONF_SCR:%=../../$(SRC_DIR)/%)
___CONF_SCR=	$(_UNIQ)$(__CONF_SCR)
____CONF_SCR=	$(___CONF_SCR:$(_UNIQ)=true)
PCONFSCRIPT=	$(____CONF_SCR:$(_UNIQ)%=%)

_LNDIR_PRG=	$(_UNIQ)$(LNDIR_PRG)
__LNDIR_PRG=	$(_LNDIR_PRG:$(_UNIQ)=:)
LNDIRPRG=	$(__LNDIR_PRG:$(_UNIQ)%=%)

#$(ARCHDIR)/config.status: $(SRC_DIR)/$(CONFSCRIPT)

			# Expands to: $(SRC_DIR)/$(CONFSCRIPT) is non-empty
$(ARCHDIR)/config.status: $(_CONF_SCR:%=$(SRC_DIR)/%)
	mkdir -p $(ARCHDIR)/; cd $(ARCHDIR)/; \
	$(LNDIRPRG) ../../$(SRC_DIR)/; \
	CC="$(XCCCOM)" CFLAGS="$(CFLAGS)" MAKE="$(MAKE)" $(MAKEMACS) $(PCONFSCRIPT) $(CONF_OPTS) && \
	( [ ! -f config.status ] && touch config.status || : )
