/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#include <goffice/utils/go-units.h>

#include "theme.h"

#ifndef PRESENTATION_H
#define PRESENTATION_H

G_BEGIN_DECLS

typedef struct _CriaPresentation	CriaPresentation;
typedef struct _CriaPresentationClass	CriaPresentationClass;
typedef struct _CriaPresentationPrivate	CriaPresentationPrivate;

#include "slide.h"

void		  cria_presentation_add_theme	       (CriaPresentation* self,
							CriaTheme	* theme);
void		  cria_presentation_append_slide       (CriaPresentation* self,
							CriaSlide	* slide);
const gchar	* cria_presentation_get_filename       (CriaPresentation* self);
GType		  cria_presentation_get_type	       (void);
const GnomeVFSURI* cria_presentation_get_uri	       (CriaPresentation* self);
CriaSlide	* cria_presentation_get_slide	       (CriaPresentation* self,
							guint		  index);
gint		  cria_presentation_get_slide_index    (CriaPresentation* self,
							CriaSlide const	* slide);
const GoPoint	* cria_presentation_get_slide_size     (CriaPresentation* self);
CriaTheme	* cria_presentation_get_theme	       (CriaPresentation* self,
							const char	* theme);
const gchar	* cria_presentation_get_title	       (CriaPresentation* self);
void		  cria_presentation_insert_slide       (CriaPresentation* self,
							CriaSlide       * slide,
							gint		  position);
guint		  cria_presentation_n_slides	       (CriaPresentation*self);
CriaPresentation* cria_presentation_new_default	       (void);
CriaPresentation* cria_presentation_new_from_file      (const	gchar	* filename,
							GError		**error);
CriaPresentation* cria_presentation_new_from_text_uri  (const gchar	* text_uri,
							GError		**error);
void		  cria_presentation_set_title	       (CriaPresentation* self,
							const char	* title);
void		  cria_presentation_set_uri	       (CriaPresentation* self,
							GnomeVFSURI	* uri);

#define CRIA_TYPE_PRESENTATION			(cria_presentation_get_type())
#define CRIA_PRESENTATION(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_PRESENTATION, CriaPresentation))
#define CRIA_PRESENTATION_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_PRESENTATION, CriaPresentationClass))
#define CRIA_IS_PRESENTATION(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_PRESENTATION))
#define CRIA_IS_PRESENTATION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_PRESENTATION))
#define CRIA_PRESENTATION_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_PRESENTATION, CriaPresentationClass))

struct _CriaPresentation {
	GObject			  base_instance;
	/* GoPoint		* size = 5760x4320; */
	/* gboolean		  saved; */
	gchar			* title;
	CriaPresentationPrivate	* priv;
};

struct _CriaPresentationClass {
	GObjectClass	  base_class;

	/* signals */
	void (*inserted_slide)	       (CriaPresentation* self,
					gint		  new_position,
					CriaSlide	* new_slide);
};

G_END_DECLS

#endif /* PRESENTATION_H */
