.\"
.\" "$Id: lpadmin.man 5327 2006-03-23 19:53:24Z mike $"
.\"
.\"   lpadmin man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636 USA
.\"
.\"       Voice: (301) 373-9600
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH lpadmin 8 "Common UNIX Printing System" "23 March 2006" "Easy Software Products"
.SH NAME
lpadmin \- configure cups printers and classes
.SH SYNOPSIS
.B lpadmin
[ -E ] [-U
.I username
] [ -h
.I server[:port]
] -d
.I destination
.br
.B lpadmin
[ -E ] [-U
.I username
] [ -h
.I server[:port]
] -p
.I printer option(s)
.br
.B lpadmin
[ -E ] [-U
.I username
] [ -h
.I server[:port]
] -x
.I destination
.SH DESCRIPTION
\fIlpadmin\fR configures printer and class queues provided by
CUPS. It can also be used to set the server default printer or
class.
.LP
When specified before the \fI-d\fR, \fI-p\fR, or \fI-x\fR
options, the \fI-E\fR option forces encryption when connecting to
the server.
.LP
The first form of the command (\fI-d\fR) sets the default printer
or class to \fIdestination\fR.  Subsequent print jobs submitted
via the \fIlp(1)\fR or \fIlpr(1)\fR commands will use this
destination unless the user specifies otherwise with the
\fIlpoptions(1)\fR command.
.LP
The second form of the command (\fI-p\fR) configures the named
printer.  The additional options are described below.
.LP
The third form of the command (\fI-x\fR) deletes the printer or
class \fIdestination\fR. Any jobs that are pending for the
destination will be removed and any job that is currently printed
will be aborted.
.SH CONFIGURATION OPTIONS
The following options are recognized when configuring a printer
queue:
.TP 5
-c class
.br
Adds the named \fIprinter\fR to \fIclass\fR.  If \fIclass\fR does
not exist it is created automatically.
.TP 5
-i interface
.br
Sets a System V style interface script for the printer. This
option cannot be specified with the \fI-P\fR option (PPD file)
and is intended for providing support for legacy printer drivers.
.TP 5
-m model
.br
Sets a standard System V interface script or PPD file from the
\fImodel\fR directory.
.TP 5
-o name=value
.br
Sets a PPD or server option for the printer. PPD options can be
listed using the \fI-l\fR option with the \fIlpoptions(1)\fR
command.
.TP 5
-o job-k-limit=value
.br
Sets the kilobyte limit for per-user quotas. The value is an
integer number of kilobytes; one kilobyte is 1024 bytes.
.TP 5
-o job-page-limit=value
.br
Sets the page limit for per-user quotas. The value is the integer
number of pages that can be printed; double-sided pages are
counted as two pages.
.TP 5
-o job-quota-period=value
.br
Sets the accounting period for per-user quotas. The value is an
integer number of seconds; 86,400 seconds are in one day.
.TP 5
-o job-sheets-default=banner
.TP 5
-o job-sheets-default=banner,banner
.br
Sets the default banner page(s) to use for print jobs.
.TP 5
-o port-monitor=name
.br
Sets the binary communications program to use when printing,
"none", "bcp", or "tbcp". The default program is "none".
.TP 5
-r class
.br
Removes the named \fIprinter\fR from \fIclass\fR.  If the
resulting class becomes empty it is removed.
.TP 5
-u allow:user,user,@group
.TP 5
-u deny:user,user,@group
.TP 5
-u allow:all
.TP 5
-u deny:none
.br
Sets user-level access control on a printer. Names starting with
"@" are interpreted as UNIX groups. The latter two forms turn
user-level access control off.
.TP 5
-v "device-uri"
.br
Sets the \fIdevice-uri\fR attribute of the printer queue.  If
\fIdevice-uri\fR is a filename it is automatically converted to
the form \fIfile:///file/name\fR.
.TP 5
-D "info"
.br
Provides a textual description of the printer.
.TP 5
-E
.br
Enables the printer and accepts jobs; this is the same as running the
\fIaccept(8)\fR and \fIcupsenable(8)\fR programs on the printer.
.TP 5
-L "location"
.br
Provides a textual location of the printer.
.TP 5
-P ppd-file
.br
Specifies a PostScript Printer Description file to use with the
printer. If specified, this option overrides the \fI-i\fR option
(interface script).
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to
contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
Finally, the CUPS version of \fIlpadmin\fR may ask the user for
an access password depending on the printing system
configuration. This differs from the System V version which
requires the root user to execute this command.
.SH LIMITATIONS
The CUPS version of \fIlpadmin\fR does not support all of the
System V or Solaris printing system configuration options.
.SH SEE ALSO
\fIaccept(8)\fR, \fIcupsenable(8)\fR, \fIlpoptions(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 1997-2006 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: lpadmin.man 5327 2006-03-23 19:53:24Z mike $".
.\"
