;; DFA-based pipeline description for 5400
(define_automaton "vr54")
(define_cpu_unit "vr54_dp0"     "vr54")
(define_cpu_unit "vr54_dp1"     "vr54")
(define_cpu_unit "vr54_mem"     "vr54")
(define_cpu_unit "vr54_mac"     "vr54")

;;
;; The ordering of the instruction-execution-path/resource-usage
;; descriptions (also known as reservation RTL) is roughly ordered
;; based on the define attribute RTL for the "type" classification.
;; When modifying, remember that the first test that matches is the
;; reservation used!
;;

(define_insn_reservation "ir_vr54_unknown" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "unknown"))
  "vr54_dp0+vr54_dp1+vr54_mem+vr54_mac")

;; Assume prediction fails.
(define_insn_reservation "ir_vr54_branch" 3
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "branch,jump,call"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_load" 2
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "load")
            (eq_attr "mode" "!SF,DF,FPSW")))
  "vr54_mem")

(define_insn_reservation "ir_vr54_store" 1
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "store")
            (eq_attr "mode" "!SF,DF,FPSW")))
  "vr54_mem")

(define_insn_reservation "ir_vr54_fstore" 1
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "store")
            (eq_attr "mode" "SF,DF")))
  "vr54_mem")


;; This reservation is for conditional move based on integer
;; or floating point CC.
(define_insn_reservation "ir_vr54_condmove" 4
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "condmove"))
  "vr54_dp0|vr54_dp1")

;; Move to/from FPU registers
(define_insn_reservation "ir_vr54_xfer" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "xfer"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_hilo" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "hilo"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_arith" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "move,arith,darith,const,icmp,nop"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imul_si" 3
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "imul")
            (eq_attr "mode" "SI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imul_di" 4
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "imul")
            (eq_attr "mode" "DI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_imadd_si" 3
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "imul"))
  "vr54_mac")

(define_insn_reservation "ir_vr54_idiv_si" 42
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "SI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_idiv_di" 74
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "DI")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fadd" 4
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fadd"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmul_sf" 5
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmul_df" 6
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmadd_sf" 9
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fmadd_df" 10
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fdiv_sf" 42
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fdiv,fsqrt")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fdiv_df" 72
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "fdiv,fsqrt")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fabs" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fabs,fneg"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fcmp" 2
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fcmp"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_fcvt" 6
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "fcvt"))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_frsqrt_sf" 61
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "SF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_frsqrt_df" 121
  (and (eq_attr "cpu" "r5400")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "DF")))
  "vr54_dp0|vr54_dp1")

(define_insn_reservation "ir_vr54_multi" 1
  (and (eq_attr "cpu" "r5400")
       (eq_attr "type" "multi"))
  "vr54_dp0+vr54_dp1+vr54_mem+vr54_mac")
