/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "base/temp-buf.h"
#include "base/tile-manager.h"
#include "base/tile.h"
#include "config/gimpcoreconfig.h"
#include "core/gimp.h"
#include "core/gimpdrawable-foreground-extract.h"
#include "core/gimpdrawable-offset.h"
#include "core/gimpdrawable-preview.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimplayermask.h"
#include "gimp-intl.h"
#include "plug-in/plug-in.h"

static ProcRecord drawable_delete_proc;
static ProcRecord drawable_is_layer_proc;
static ProcRecord drawable_is_layer_mask_proc;
static ProcRecord drawable_is_channel_proc;
static ProcRecord drawable_type_proc;
static ProcRecord drawable_type_with_alpha_proc;
static ProcRecord drawable_has_alpha_proc;
static ProcRecord drawable_is_rgb_proc;
static ProcRecord drawable_is_gray_proc;
static ProcRecord drawable_is_indexed_proc;
static ProcRecord drawable_bpp_proc;
static ProcRecord drawable_width_proc;
static ProcRecord drawable_height_proc;
static ProcRecord drawable_offsets_proc;
static ProcRecord drawable_get_image_proc;
static ProcRecord drawable_set_image_proc;
static ProcRecord drawable_get_name_proc;
static ProcRecord drawable_set_name_proc;
static ProcRecord drawable_get_visible_proc;
static ProcRecord drawable_set_visible_proc;
static ProcRecord drawable_get_linked_proc;
static ProcRecord drawable_set_linked_proc;
static ProcRecord drawable_get_tattoo_proc;
static ProcRecord drawable_set_tattoo_proc;
static ProcRecord drawable_mask_bounds_proc;
static ProcRecord drawable_mask_intersect_proc;
static ProcRecord drawable_merge_shadow_proc;
static ProcRecord drawable_update_proc;
static ProcRecord drawable_get_pixel_proc;
static ProcRecord drawable_set_pixel_proc;
static ProcRecord drawable_fill_proc;
static ProcRecord drawable_offset_proc;
static ProcRecord drawable_thumbnail_proc;
static ProcRecord drawable_sub_thumbnail_proc;
static ProcRecord drawable_foreground_extract_proc;

void
register_drawable_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &drawable_delete_proc);
  procedural_db_register (gimp, &drawable_is_layer_proc);
  procedural_db_register (gimp, &drawable_is_layer_mask_proc);
  procedural_db_register (gimp, &drawable_is_channel_proc);
  procedural_db_register (gimp, &drawable_type_proc);
  procedural_db_register (gimp, &drawable_type_with_alpha_proc);
  procedural_db_register (gimp, &drawable_has_alpha_proc);
  procedural_db_register (gimp, &drawable_is_rgb_proc);
  procedural_db_register (gimp, &drawable_is_gray_proc);
  procedural_db_register (gimp, &drawable_is_indexed_proc);
  procedural_db_register (gimp, &drawable_bpp_proc);
  procedural_db_register (gimp, &drawable_width_proc);
  procedural_db_register (gimp, &drawable_height_proc);
  procedural_db_register (gimp, &drawable_offsets_proc);
  procedural_db_register (gimp, &drawable_get_image_proc);
  procedural_db_register (gimp, &drawable_set_image_proc);
  procedural_db_register (gimp, &drawable_get_name_proc);
  procedural_db_register (gimp, &drawable_set_name_proc);
  procedural_db_register (gimp, &drawable_get_visible_proc);
  procedural_db_register (gimp, &drawable_set_visible_proc);
  procedural_db_register (gimp, &drawable_get_linked_proc);
  procedural_db_register (gimp, &drawable_set_linked_proc);
  procedural_db_register (gimp, &drawable_get_tattoo_proc);
  procedural_db_register (gimp, &drawable_set_tattoo_proc);
  procedural_db_register (gimp, &drawable_mask_bounds_proc);
  procedural_db_register (gimp, &drawable_mask_intersect_proc);
  procedural_db_register (gimp, &drawable_merge_shadow_proc);
  procedural_db_register (gimp, &drawable_update_proc);
  procedural_db_register (gimp, &drawable_get_pixel_proc);
  procedural_db_register (gimp, &drawable_set_pixel_proc);
  procedural_db_register (gimp, &drawable_fill_proc);
  procedural_db_register (gimp, &drawable_offset_proc);
  procedural_db_register (gimp, &drawable_thumbnail_proc);
  procedural_db_register (gimp, &drawable_sub_thumbnail_proc);
  procedural_db_register (gimp, &drawable_foreground_extract_proc);
}

static Argument *
drawable_delete_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  if (success)
    {
      success = gimp_item_is_floating (GIMP_ITEM (drawable));

      if (success)
        gimp_item_sink (GIMP_ITEM (drawable));
    }

  return procedural_db_return_args (&drawable_delete_proc, success);
}

static ProcArg drawable_delete_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable to delete"
  }
};

static ProcRecord drawable_delete_proc =
{
  "gimp-drawable-delete",
  "gimp-drawable-delete",
  "Delete a drawable.",
  "This procedure deletes the specified drawable. This must not be done if the gimage containing this drawable was already deleted or if the drawable was already removed from the image. The only case in which this procedure is useful is if you want to get rid of a drawable which has not yet been added to an image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_delete_inargs,
  0,
  NULL,
  { { drawable_delete_invoker } }
};

static Argument *
drawable_is_layer_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_layer_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_IS_LAYER (drawable) ? TRUE : FALSE;

  return return_args;
}

static ProcArg drawable_is_layer_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_layer_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "layer",
    "Non-zero if the drawable is a layer"
  }
};

static ProcRecord drawable_is_layer_proc =
{
  "gimp-drawable-is-layer",
  "gimp-drawable-is-layer",
  "Returns whether the drawable is a layer.",
  "This procedure returns non-zero if the specified drawable is a layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_layer_inargs,
  1,
  drawable_is_layer_outargs,
  { { drawable_is_layer_invoker } }
};

static Argument *
drawable_is_layer_mask_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_layer_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_IS_LAYER_MASK (drawable) ? TRUE : FALSE;

  return return_args;
}

static ProcArg drawable_is_layer_mask_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_layer_mask_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "layer-mask",
    "Non-zero if the drawable is a layer mask"
  }
};

static ProcRecord drawable_is_layer_mask_proc =
{
  "gimp-drawable-is-layer-mask",
  "gimp-drawable-is-layer-mask",
  "Returns whether the drawable is a layer mask.",
  "This procedure returns non-zero if the specified drawable is a layer mask.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_layer_mask_inargs,
  1,
  drawable_is_layer_mask_outargs,
  { { drawable_is_layer_mask_invoker } }
};

static Argument *
drawable_is_channel_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_channel_proc, success);

  if (success)
    return_args[1].value.pdb_int = GIMP_IS_CHANNEL (drawable) ? TRUE : FALSE;

  return return_args;
}

static ProcArg drawable_is_channel_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_channel_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "channel",
    "Non-zero if the drawable is a channel"
  }
};

static ProcRecord drawable_is_channel_proc =
{
  "gimp-drawable-is-channel",
  "gimp-drawable-is-channel",
  "Returns whether the drawable is a channel.",
  "This procedure returns non-zero if the specified drawable is a channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_channel_inargs,
  1,
  drawable_is_channel_outargs,
  { { drawable_is_channel_invoker } }
};

static Argument *
drawable_type_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_type_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_type (drawable);

  return return_args;
}

static ProcArg drawable_type_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_type_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "type",
    "The drawable's type: { GIMP_RGB_IMAGE (0), GIMP_RGBA_IMAGE (1), GIMP_GRAY_IMAGE (2), GIMP_GRAYA_IMAGE (3), GIMP_INDEXED_IMAGE (4), GIMP_INDEXEDA_IMAGE (5) }"
  }
};

static ProcRecord drawable_type_proc =
{
  "gimp-drawable-type",
  "gimp-drawable-type",
  "Returns the drawable's type.",
  "This procedure returns the drawable's type.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_type_inargs,
  1,
  drawable_type_outargs,
  { { drawable_type_invoker } }
};

static Argument *
drawable_type_with_alpha_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_type_with_alpha_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_type_with_alpha (drawable);

  return return_args;
}

static ProcArg drawable_type_with_alpha_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_type_with_alpha_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "type-with-alpha",
    "The drawable's type with alpha: { GIMP_RGB_IMAGE (0), GIMP_RGBA_IMAGE (1), GIMP_GRAY_IMAGE (2), GIMP_GRAYA_IMAGE (3), GIMP_INDEXED_IMAGE (4), GIMP_INDEXEDA_IMAGE (5) }"
  }
};

static ProcRecord drawable_type_with_alpha_proc =
{
  "gimp-drawable-type-with-alpha",
  "gimp-drawable-type-with-alpha",
  "Returns the drawable's type with alpha.",
  "This procedure returns the drawable's type as if had an alpha channel. If the type is currently Gray, for instance, the returned type would be GrayA. If the drawable already has an alpha channel, the drawable's type is simply returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_type_with_alpha_inargs,
  1,
  drawable_type_with_alpha_outargs,
  { { drawable_type_with_alpha_invoker } }
};

static Argument *
drawable_has_alpha_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_has_alpha_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_has_alpha (drawable);

  return return_args;
}

static ProcArg drawable_has_alpha_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_has_alpha_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "has-alpha",
    "Does the drawable have an alpha channel?"
  }
};

static ProcRecord drawable_has_alpha_proc =
{
  "gimp-drawable-has-alpha",
  "gimp-drawable-has-alpha",
  "Returns non-zero if the drawable has an alpha channel.",
  "This procedure returns whether the specified drawable has an alpha channel. This can only be true for layers, and the associated type will be one of: { RGBA , GRAYA, INDEXEDA }.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_has_alpha_inargs,
  1,
  drawable_has_alpha_outargs,
  { { drawable_has_alpha_invoker } }
};

static Argument *
drawable_is_rgb_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_rgb_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_is_rgb (drawable);

  return return_args;
}

static ProcArg drawable_is_rgb_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_rgb_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "is-rgb",
    "non-zero if the drawable is an RGB type"
  }
};

static ProcRecord drawable_is_rgb_proc =
{
  "gimp-drawable-is-rgb",
  "gimp-drawable-is-rgb",
  "Returns whether the drawable is an RGB type.",
  "This procedure returns non-zero if the specified drawable is of type { RGB, RGBA }.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_rgb_inargs,
  1,
  drawable_is_rgb_outargs,
  { { drawable_is_rgb_invoker } }
};

static Argument *
drawable_is_gray_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_gray_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_is_gray (drawable);

  return return_args;
}

static ProcArg drawable_is_gray_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_gray_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "is-gray",
    "non-zero if the drawable is a grayscale type"
  }
};

static ProcRecord drawable_is_gray_proc =
{
  "gimp-drawable-is-gray",
  "gimp-drawable-is-gray",
  "Returns whether the drawable is a grayscale type.",
  "This procedure returns non-zero if the specified drawable is of type { Gray, GrayA }.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_gray_inargs,
  1,
  drawable_is_gray_outargs,
  { { drawable_is_gray_invoker } }
};

static Argument *
drawable_is_indexed_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_is_indexed_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_is_indexed (drawable);

  return return_args;
}

static ProcArg drawable_is_indexed_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_is_indexed_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "is-indexed",
    "non-zero if the drawable is an indexed type"
  }
};

static ProcRecord drawable_is_indexed_proc =
{
  "gimp-drawable-is-indexed",
  "gimp-drawable-is-indexed",
  "Returns whether the drawable is an indexed type.",
  "This procedure returns non-zero if the specified drawable is of type { Indexed, IndexedA }.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_is_indexed_inargs,
  1,
  drawable_is_indexed_outargs,
  { { drawable_is_indexed_invoker } }
};

static Argument *
drawable_bpp_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_bpp_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_drawable_bytes (drawable);

  return return_args;
}

static ProcArg drawable_bpp_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_bpp_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "bpp",
    "Bytes per pixel"
  }
};

static ProcRecord drawable_bpp_proc =
{
  "gimp-drawable-bpp",
  "gimp-drawable-bpp",
  "Returns the bytes per pixel.",
  "This procedure returns the number of bytes per pixel (or the number of channels) for the specified drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_bpp_inargs,
  1,
  drawable_bpp_outargs,
  { { drawable_bpp_invoker } }
};

static Argument *
drawable_width_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_width_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_width (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg drawable_width_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_width_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "Width of drawable"
  }
};

static ProcRecord drawable_width_proc =
{
  "gimp-drawable-width",
  "gimp-drawable-width",
  "Returns the width of the drawable.",
  "This procedure returns the specified drawable's width in pixels.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_width_inargs,
  1,
  drawable_width_outargs,
  { { drawable_width_invoker } }
};

static Argument *
drawable_height_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_height_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_height (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg drawable_height_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_height_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "height",
    "Height of drawable"
  }
};

static ProcRecord drawable_height_proc =
{
  "gimp-drawable-height",
  "gimp-drawable-height",
  "Returns the height of the drawable.",
  "This procedure returns the specified drawable's height in pixels.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_height_inargs,
  1,
  drawable_height_outargs,
  { { drawable_height_invoker } }
};

static Argument *
drawable_offsets_invoker (Gimp         *gimp,
                          GimpContext  *context,
                          GimpProgress *progress,
                          Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gint32 offset_x;
  gint32 offset_y;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  if (success)
    gimp_item_offsets (GIMP_ITEM (drawable), &offset_x, &offset_y);

  return_args = procedural_db_return_args (&drawable_offsets_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = offset_x;
      return_args[2].value.pdb_int = offset_y;
    }

  return return_args;
}

static ProcArg drawable_offsets_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_offsets_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "offset-x",
    "x offset of drawable"
  },
  {
    GIMP_PDB_INT32,
    "offset-y",
    "y offset of drawable"
  }
};

static ProcRecord drawable_offsets_proc =
{
  "gimp-drawable-offsets",
  "gimp-drawable-offsets",
  "Returns the offsets for the drawable.",
  "This procedure returns the specified drawable's offsets. This only makes sense if the drawable is a layer since channels are anchored. The offsets of a channel will be returned as 0.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_offsets_inargs,
  2,
  drawable_offsets_outargs,
  { { drawable_offsets_invoker } }
};

static Argument *
drawable_get_image_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  GimpImage *gimage = NULL;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  if (success)
    success = (gimage = gimp_item_get_image (GIMP_ITEM (drawable))) != NULL;

  return_args = procedural_db_return_args (&drawable_get_image_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_image_get_ID (gimage);

  return return_args;
}

static ProcArg drawable_get_image_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_get_image_outargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The drawable's image"
  }
};

static ProcRecord drawable_get_image_proc =
{
  "gimp-drawable-get-image",
  "gimp-drawable-get-image",
  "Returns the drawable's image.",
  "This procedure returns the drawable's image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_get_image_inargs,
  1,
  drawable_get_image_outargs,
  { { drawable_get_image_invoker } }
};

static Argument *
drawable_set_image_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpImage *gimage;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  gimage = gimp_image_get_by_ID (gimp, args[1].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  if (success)
    {
      success = (gimage == gimp_item_get_image (GIMP_ITEM (drawable)));
    }

  return procedural_db_return_args (&drawable_set_image_proc, success);
}

static ProcArg drawable_set_image_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image"
  }
};

static ProcRecord drawable_set_image_proc =
{
  "gimp-drawable-set-image",
  "gimp-drawable-set-image",
  "This procedure is deprecated!",
  "This procedure is deprecated!",
  "",
  "",
  "",
  "NONE",
  GIMP_INTERNAL,
  2,
  drawable_set_image_inargs,
  0,
  NULL,
  { { drawable_set_image_invoker } }
};

static Argument *
drawable_get_name_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_get_name_proc, success);

  if (success)
    return_args[1].value.pdb_pointer = g_strdup (gimp_object_get_name (GIMP_OBJECT (drawable)));

  return return_args;
}

static ProcArg drawable_get_name_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_get_name_outargs[] =
{
  {
    GIMP_PDB_STRING,
    "name",
    "The drawable name"
  }
};

static ProcRecord drawable_get_name_proc =
{
  "gimp-drawable-get-name",
  "gimp-drawable-get-name",
  "Get the name of the specified drawable.",
  "This procedure returns the specified drawable's name.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_get_name_inargs,
  1,
  drawable_get_name_outargs,
  { { drawable_get_name_invoker } }
};

static Argument *
drawable_set_name_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gchar *name;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  name = (gchar *) args[1].value.pdb_pointer;
  if (name == NULL || !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  if (success)
    success = gimp_item_rename (GIMP_ITEM (drawable), name);

  return procedural_db_return_args (&drawable_set_name_proc, success);
}

static ProcArg drawable_set_name_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_STRING,
    "name",
    "The new drawable name"
  }
};

static ProcRecord drawable_set_name_proc =
{
  "gimp-drawable-set-name",
  "gimp-drawable-set-name",
  "Set the name of the specified drawable.",
  "This procedure sets the specified drawable's name.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_set_name_inargs,
  0,
  NULL,
  { { drawable_set_name_invoker } }
};

static Argument *
drawable_get_visible_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_get_visible_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_visible (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg drawable_get_visible_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_get_visible_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "visible",
    "The drawable visibility"
  }
};

static ProcRecord drawable_get_visible_proc =
{
  "gimp-drawable-get-visible",
  "gimp-drawable-get-visible",
  "Get the visibility of the specified drawable.",
  "This procedure returns the specified drawable's visibility.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_get_visible_inargs,
  1,
  drawable_get_visible_outargs,
  { { drawable_get_visible_invoker } }
};

static Argument *
drawable_set_visible_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gboolean visible;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  visible = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_item_set_visible (GIMP_ITEM (drawable), visible, TRUE);

  return procedural_db_return_args (&drawable_set_visible_proc, success);
}

static ProcArg drawable_set_visible_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "visible",
    "The new drawable visibility"
  }
};

static ProcRecord drawable_set_visible_proc =
{
  "gimp-drawable-set-visible",
  "gimp-drawable-set-visible",
  "Set the visibility of the specified drawable.",
  "This procedure sets the specified drawable's visibility.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_set_visible_inargs,
  0,
  NULL,
  { { drawable_set_visible_invoker } }
};

static Argument *
drawable_get_linked_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_get_linked_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_linked (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg drawable_get_linked_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_get_linked_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "linked",
    "The drawable linked state (for moves)"
  }
};

static ProcRecord drawable_get_linked_proc =
{
  "gimp-drawable-get-linked",
  "gimp-drawable-get-linked",
  "Get the linked state of the specified drawable.",
  "This procedure returns the specified drawable's linked state.",
  "Wolfgang Hofer",
  "Wolfgang Hofer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_get_linked_inargs,
  1,
  drawable_get_linked_outargs,
  { { drawable_get_linked_invoker } }
};

static Argument *
drawable_set_linked_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gboolean linked;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  linked = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_item_set_linked (GIMP_ITEM (drawable), linked, TRUE);

  return procedural_db_return_args (&drawable_set_linked_proc, success);
}

static ProcArg drawable_set_linked_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "linked",
    "The new drawable linked state"
  }
};

static ProcRecord drawable_set_linked_proc =
{
  "gimp-drawable-set-linked",
  "gimp-drawable-set-linked",
  "Set the linked state of the specified drawable.",
  "This procedure sets the specified drawable's linked state.",
  "Wolfgang Hofer",
  "Wolfgang Hofer",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_set_linked_inargs,
  0,
  NULL,
  { { drawable_set_linked_invoker } }
};

static Argument *
drawable_get_tattoo_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  return_args = procedural_db_return_args (&drawable_get_tattoo_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_tattoo (GIMP_ITEM (drawable));

  return return_args;
}

static ProcArg drawable_get_tattoo_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_get_tattoo_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "tattoo",
    "The drawable tattoo"
  }
};

static ProcRecord drawable_get_tattoo_proc =
{
  "gimp-drawable-get-tattoo",
  "gimp-drawable-get-tattoo",
  "Get the tattoo of the specified drawable.",
  "This procedure returns the specified drawable's tattoo. A tattoo is a unique and permanent identifier attached to a drawable that can be used to uniquely identify a drawable within an image even between sessions",
  "Jay Cox",
  "Jay Cox",
  "1998",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_get_tattoo_inargs,
  1,
  drawable_get_tattoo_outargs,
  { { drawable_get_tattoo_invoker } }
};

static Argument *
drawable_set_tattoo_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 tattoo;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  tattoo = args[1].value.pdb_int;
  if (tattoo == 0)
    success = FALSE;

  if (success)
    gimp_item_set_tattoo (GIMP_ITEM (drawable), tattoo);

  return procedural_db_return_args (&drawable_set_tattoo_proc, success);
}

static ProcArg drawable_set_tattoo_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "tattoo",
    "The new drawable tattoo"
  }
};

static ProcRecord drawable_set_tattoo_proc =
{
  "gimp-drawable-set-tattoo",
  "gimp-drawable-set-tattoo",
  "Set the tattoo of the specified drawable.",
  "This procedure sets the specified drawable's tattoo. A tattoo is a unique and permanent identifier attached to a drawable that can be used to uniquely identify a drawable within an image even between sessions",
  "Jay Cox",
  "Jay Cox",
  "1998",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_set_tattoo_inargs,
  0,
  NULL,
  { { drawable_set_tattoo_invoker } }
};

static Argument *
drawable_mask_bounds_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean non_empty = FALSE;
  gint32 x1;
  gint32 y1;
  gint32 x2;
  gint32 y2;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  if (success)
    non_empty = gimp_drawable_mask_bounds (drawable, &x1, &y1, &x2, &y2);

  return_args = procedural_db_return_args (&drawable_mask_bounds_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = non_empty;
      return_args[2].value.pdb_int = x1;
      return_args[3].value.pdb_int = y1;
      return_args[4].value.pdb_int = x2;
      return_args[5].value.pdb_int = y2;
    }

  return return_args;
}

static ProcArg drawable_mask_bounds_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_mask_bounds_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "non-empty",
    "TRUE if there is a selection"
  },
  {
    GIMP_PDB_INT32,
    "x1",
    "x coordinate of the upper left corner of selection bounds"
  },
  {
    GIMP_PDB_INT32,
    "y1",
    "y coordinate of the upper left corner of selection bounds"
  },
  {
    GIMP_PDB_INT32,
    "x2",
    "x coordinate of the lower right corner of selection bounds"
  },
  {
    GIMP_PDB_INT32,
    "y2",
    "y coordinate of the lower right corner of selection bounds"
  }
};

static ProcRecord drawable_mask_bounds_proc =
{
  "gimp-drawable-mask-bounds",
  "gimp-drawable-mask-bounds",
  "Find the bounding box of the current selection in relation to the specified drawable.",
  "This procedure returns whether there is a selection. If there is one, the upper left and lower righthand corners of its bounding box are returned. These coordinates are specified relative to the drawable's origin, and bounded by the drawable's extents. Please note that the pixel specified by the lower righthand coordinate of the bounding box is not part of the selection. The selection ends at the upper left corner of this pixel. This means the width of the selection can be calculated as (x2 - x1), its height as (y2 - y1). Note that the returned boolean does NOT correspond with the returned region being empty or not, it always returns whether the selection is non_empty. See gimp_drawable_mask_intersect() for a boolean return value which is more useful in most cases.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_mask_bounds_inargs,
  5,
  drawable_mask_bounds_outargs,
  { { drawable_mask_bounds_invoker } }
};

static Argument *
drawable_mask_intersect_invoker (Gimp         *gimp,
                                 GimpContext  *context,
                                 GimpProgress *progress,
                                 Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gboolean non_empty = FALSE;
  gint32 x;
  gint32 y;
  gint32 width;
  gint32 height;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  if (success)
    non_empty = gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height);

  return_args = procedural_db_return_args (&drawable_mask_intersect_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = non_empty;
      return_args[2].value.pdb_int = x;
      return_args[3].value.pdb_int = y;
      return_args[4].value.pdb_int = width;
      return_args[5].value.pdb_int = height;
    }

  return return_args;
}

static ProcArg drawable_mask_intersect_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  }
};

static ProcArg drawable_mask_intersect_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "non-empty",
    "TRUE if the returned area is not empty"
  },
  {
    GIMP_PDB_INT32,
    "x",
    "x coordinate of the upper left corner of the intersection"
  },
  {
    GIMP_PDB_INT32,
    "y",
    "y coordinate of the upper left corner of the intersection"
  },
  {
    GIMP_PDB_INT32,
    "width",
    "width of the intersection"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "height of the intersection"
  }
};

static ProcRecord drawable_mask_intersect_proc =
{
  "gimp-drawable-mask-intersect",
  "gimp-drawable-mask-intersect",
  "Find the bounding box of the current selection in relation to the specified drawable.",
  "This procedure returns whether there is an intersection between the drawable and the selection. Unlike gimp_drawable_mask_bounds(), the intersection's bounds are returned as x, y, width, height. If there is no selection this function returns TRUE and the returned bounds are the extents of the whole drawable.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  drawable_mask_intersect_inargs,
  5,
  drawable_mask_intersect_outargs,
  { { drawable_mask_intersect_invoker } }
};

static Argument *
drawable_merge_shadow_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gboolean undo;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  undo = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success)
        {
          gchar *undo_desc = NULL;

          if (gimp->current_plug_in)
            undo_desc = plug_in_get_undo_desc (gimp->current_plug_in);

          if (! undo_desc)
            undo_desc = g_strdup (_("Plug-In"));

          gimp_drawable_merge_shadow (drawable, undo, undo_desc);

          g_free (undo_desc);
        }
    }

  return procedural_db_return_args (&drawable_merge_shadow_proc, success);
}

static ProcArg drawable_merge_shadow_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "undo",
    "Push merge to undo stack?"
  }
};

static ProcRecord drawable_merge_shadow_proc =
{
  "gimp-drawable-merge-shadow",
  "gimp-drawable-merge-shadow",
  "Merge the shadow buffer with the specified drawable.",
  "This procedure combines the contents of the image's shadow buffer (for temporary processing) with the specified drawable. The \"undo\" parameter specifies whether to add an undo step for the operation. Requesting no undo is useful for such applications as 'auto-apply'.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_merge_shadow_inargs,
  0,
  NULL,
  { { drawable_merge_shadow_invoker } }
};

static Argument *
drawable_update_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 x;
  gint32 y;
  gint32 width;
  gint32 height;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  x = args[1].value.pdb_int;

  y = args[2].value.pdb_int;

  width = args[3].value.pdb_int;

  height = args[4].value.pdb_int;

  if (success)
    gimp_drawable_update (drawable, x, y, width, height);

  return procedural_db_return_args (&drawable_update_proc, success);
}

static ProcArg drawable_update_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "x",
    "x coordinate of upper left corner of update region"
  },
  {
    GIMP_PDB_INT32,
    "y",
    "y coordinate of upper left corner of update region"
  },
  {
    GIMP_PDB_INT32,
    "width",
    "Width of update region"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "Height of update region"
  }
};

static ProcRecord drawable_update_proc =
{
  "gimp-drawable-update",
  "gimp-drawable-update",
  "Update the specified region of the drawable.",
  "This procedure updates the specified region of the drawable. The (x, y) coordinate pair is relative to the drawable's origin, not to the image origin. Therefore, the entire drawable can be updated using (0, 0, width, height).",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  5,
  drawable_update_inargs,
  0,
  NULL,
  { { drawable_update_invoker } }
};

static Argument *
drawable_get_pixel_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gint32 x;
  gint32 y;
  gint32 num_channels = 0;
  guint8 *pixel = NULL;
  guint8 *p;
  gint b;
  Tile *tile;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  x = args[1].value.pdb_int;
  if (x < 0)
    success = FALSE;

  y = args[2].value.pdb_int;
  if (y < 0)
    success = FALSE;

  if (success)
    {
      if (x < gimp_item_width  (GIMP_ITEM (drawable)) &&
          y < gimp_item_height (GIMP_ITEM (drawable)))
        {
          num_channels = gimp_drawable_bytes (drawable);
          pixel = g_new (guint8, num_channels);

          tile = tile_manager_get_tile (gimp_drawable_data (drawable), x, y,
                                        TRUE, TRUE);

          x %= TILE_WIDTH;
          y %= TILE_HEIGHT;

          p = tile_data_pointer (tile, x, y);
          for (b = 0; b < num_channels; b++)
            pixel[b] = p[b];

          tile_release (tile, FALSE);
        }
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&drawable_get_pixel_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_channels;
      return_args[2].value.pdb_pointer = pixel;
    }

  return return_args;
}

static ProcArg drawable_get_pixel_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "x-coord",
    "The x coordinate"
  },
  {
    GIMP_PDB_INT32,
    "y-coord",
    "The y coordinate"
  }
};

static ProcArg drawable_get_pixel_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num-channels",
    "The number of channels for the pixel"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "pixel",
    "The pixel value"
  }
};

static ProcRecord drawable_get_pixel_proc =
{
  "gimp-drawable-get-pixel",
  "gimp-drawable-get-pixel",
  "Gets the value of the pixel at the specified coordinates.",
  "This procedure gets the pixel value at the specified coordinates. The 'num_channels' argument must always be equal to the bytes-per-pixel value for the specified drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  NULL,
  GIMP_INTERNAL,
  3,
  drawable_get_pixel_inargs,
  2,
  drawable_get_pixel_outargs,
  { { drawable_get_pixel_invoker } }
};

static Argument *
drawable_set_pixel_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 x;
  gint32 y;
  gint32 num_channels;
  guint8 *pixel;
  guint8 *p;
  gint b;
  Tile *tile;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  x = args[1].value.pdb_int;
  if (x < 0)
    success = FALSE;

  y = args[2].value.pdb_int;
  if (y < 0)
    success = FALSE;

  num_channels = args[3].value.pdb_int;

  pixel = (guint8 *) args[4].value.pdb_pointer;

  if (success)
    {
      if (x < gimp_item_width  (GIMP_ITEM (drawable)) &&
          y < gimp_item_height (GIMP_ITEM (drawable)) &&
          num_channels == gimp_drawable_bytes (drawable))
        {
          tile = tile_manager_get_tile (gimp_drawable_data (drawable), x, y,
                                        TRUE, TRUE);

          x %= TILE_WIDTH;
          y %= TILE_HEIGHT;

          p = tile_data_pointer (tile, x, y);
          for (b = 0; b < num_channels; b++)
            *p++ = *pixel++;

          tile_release (tile, TRUE);
        }
      else
        success = FALSE;
    }

  return procedural_db_return_args (&drawable_set_pixel_proc, success);
}

static ProcArg drawable_set_pixel_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "x-coord",
    "The x coordinate"
  },
  {
    GIMP_PDB_INT32,
    "y-coord",
    "The y coordinate"
  },
  {
    GIMP_PDB_INT32,
    "num-channels",
    "The number of channels for the pixel"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "pixel",
    "The pixel value"
  }
};

static ProcRecord drawable_set_pixel_proc =
{
  "gimp-drawable-set-pixel",
  "gimp-drawable-set-pixel",
  "Sets the value of the pixel at the specified coordinates.",
  "This procedure sets the pixel value at the specified coordinates. The 'num_channels' argument must always be equal to the bytes-per-pixel value for the specified drawable. Note that this function is not undoable, you should use it only on drawables you just created yourself.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  NULL,
  GIMP_INTERNAL,
  5,
  drawable_set_pixel_inargs,
  0,
  NULL,
  { { drawable_set_pixel_invoker } }
};

static Argument *
drawable_fill_invoker (Gimp         *gimp,
                       GimpContext  *context,
                       GimpProgress *progress,
                       Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 fill_type;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  fill_type = args[1].value.pdb_int;
  if (fill_type < GIMP_FOREGROUND_FILL || fill_type > GIMP_PATTERN_FILL)
    success = FALSE;

  if (success)
    gimp_drawable_fill_by_type (drawable, context, (GimpFillType) fill_type);

  return procedural_db_return_args (&drawable_fill_proc, success);
}

static ProcArg drawable_fill_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "fill-type",
    "The type of fill: GIMP_FOREGROUND_FILL (0), GIMP_BACKGROUND_FILL (1), GIMP_WHITE_FILL (2), GIMP_TRANSPARENT_FILL (3), GIMP_PATTERN_FILL (4)"
  }
};

static ProcRecord drawable_fill_proc =
{
  "gimp-drawable-fill",
  "gimp-drawable-fill",
  "Fill the drawable with the specified fill mode.",
  "This procedure fills the drawable with the fill mode. If the fill mode is foreground the current foreground color is used. If the fill mode is background, the current background color is used. If the fill type is white, then white is used. Transparent fill only affects layers with an alpha channel, in which case the alpha channel is set to transparent. If the drawable has no alpha channel, it is filled to white. No fill leaves the drawable's contents undefined. This procedure is unlike the bucket fill tool because it fills regardless of a selection",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  drawable_fill_inargs,
  0,
  NULL,
  { { drawable_fill_invoker } }
};

static Argument *
drawable_offset_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gboolean wrap_around;
  gint32 fill_type;
  gint32 offset_x;
  gint32 offset_y;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  wrap_around = args[1].value.pdb_int ? TRUE : FALSE;

  fill_type = args[2].value.pdb_int;
  if (fill_type < GIMP_OFFSET_BACKGROUND || fill_type > GIMP_OFFSET_TRANSPARENT)
    success = FALSE;

  offset_x = args[3].value.pdb_int;

  offset_y = args[4].value.pdb_int;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success)
        gimp_drawable_offset (drawable, context, wrap_around, fill_type,
                              offset_x, offset_y);
    }

  return procedural_db_return_args (&drawable_offset_proc, success);
}

static ProcArg drawable_offset_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable to offset"
  },
  {
    GIMP_PDB_INT32,
    "wrap-around",
    "wrap image around or fill vacated regions"
  },
  {
    GIMP_PDB_INT32,
    "fill-type",
    "fill vacated regions of drawable with background or transparent: GIMP_OFFSET_BACKGROUND (0) or GIMP_OFFSET_TRANSPARENT (1)"
  },
  {
    GIMP_PDB_INT32,
    "offset-x",
    "offset by this amount in X direction"
  },
  {
    GIMP_PDB_INT32,
    "offset-y",
    "offset by this amount in Y direction"
  }
};

static ProcRecord drawable_offset_proc =
{
  "gimp-drawable-offset",
  "gimp-drawable-offset",
  "Offset the drawable by the specified amounts in the X and Y directions",
  "This procedure offsets the specified drawable by the amounts specified by 'offset_x' and 'offset_y'. If 'wrap_around' is set to TRUE, then portions of the drawable which are offset out of bounds are wrapped around. Alternatively, the undefined regions of the drawable can be filled with transparency or the background color, as specified by the 'fill_type' parameter.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1997",
  NULL,
  GIMP_INTERNAL,
  5,
  drawable_offset_inargs,
  0,
  NULL,
  { { drawable_offset_invoker } }
};

static Argument *
drawable_thumbnail_invoker (Gimp         *gimp,
                            GimpContext  *context,
                            GimpProgress *progress,
                            Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gint32 req_width;
  gint32 req_height;
  gint32 width = 0;
  gint32 height = 0;
  gint32 bpp = 0;
  gint32 num_bytes = 0;
  guint8 *thumbnail_data = NULL;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  req_width = args[1].value.pdb_int;
  if (req_width <= 0 || req_width > 512)
    success = FALSE;

  req_height = args[2].value.pdb_int;
  if (req_height <= 0 || req_height > 512)
    success = FALSE;

  if (success)
    {
      GimpImage *gimage = gimp_item_get_image (GIMP_ITEM (drawable));
      TempBuf   *buf;
      gint       dwidth, dheight;

      /* Adjust the width/height ratio */
      dwidth  = gimp_item_width  (GIMP_ITEM (drawable));
      dheight = gimp_item_height (GIMP_ITEM (drawable));

      if (dwidth > dheight)
        req_height = MAX (1, (req_width * dheight) / dwidth);
      else
        req_width  = MAX (1, (req_height * dwidth) / dheight);

      if (gimage->gimp->config->layer_previews)
        buf = gimp_viewable_get_new_preview (GIMP_VIEWABLE (drawable),
                                             req_width, req_height);
      else
        buf = gimp_viewable_get_dummy_preview (GIMP_VIEWABLE (drawable),
                                               req_width, req_height,
                                               gimp_drawable_has_alpha (drawable) ?
                                               4 : 3);

      if (buf)
        {
          num_bytes      = buf->height * buf->width * buf->bytes;
          thumbnail_data = g_memdup (temp_buf_data (buf), num_bytes);
          width          = buf->width;
          height         = buf->height;
          bpp            = buf->bytes;

          temp_buf_free (buf);
        }
      else
        {
          success = FALSE;
        }
    }

  return_args = procedural_db_return_args (&drawable_thumbnail_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = width;
      return_args[2].value.pdb_int = height;
      return_args[3].value.pdb_int = bpp;
      return_args[4].value.pdb_int = num_bytes;
      return_args[5].value.pdb_pointer = thumbnail_data;
    }

  return return_args;
}

static ProcArg drawable_thumbnail_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "width",
    "The thumbnail width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The thumbnail height"
  }
};

static ProcArg drawable_thumbnail_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The previews width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The previews height"
  },
  {
    GIMP_PDB_INT32,
    "bpp",
    "The previews bpp"
  },
  {
    GIMP_PDB_INT32,
    "thumbnail-data-count",
    "The number of bytes in thumbnail data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "thumbnail-data",
    "The thumbnail data"
  }
};

static ProcRecord drawable_thumbnail_proc =
{
  "gimp-drawable-thumbnail",
  "gimp-drawable-thumbnail",
  "Get a thumbnail of a drawable.",
  "This function gets data from which a thumbnail of a drawable preview can be created. Maximum x or y dimension is 512 pixels. The pixels are returned in RGB[A] or GRAY[A] format. The bpp return value gives the number of bytes in the image.",
  "Andy Thomas",
  "Andy Thomas",
  "1999",
  NULL,
  GIMP_INTERNAL,
  3,
  drawable_thumbnail_inargs,
  5,
  drawable_thumbnail_outargs,
  { { drawable_thumbnail_invoker } }
};

static Argument *
drawable_sub_thumbnail_invoker (Gimp         *gimp,
                                GimpContext  *context,
                                GimpProgress *progress,
                                Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  gint32 src_x;
  gint32 src_y;
  gint32 src_width;
  gint32 src_height;
  gint32 dest_width;
  gint32 dest_height;
  gint32 width = 0;
  gint32 height = 0;
  gint32 bpp = 0;
  gint32 num_bytes = 0;
  guint8 *thumbnail_data = NULL;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  src_x = args[1].value.pdb_int;
  if (src_x < 0)
    success = FALSE;

  src_y = args[2].value.pdb_int;
  if (src_y < 0)
    success = FALSE;

  src_width = args[3].value.pdb_int;
  if (src_width <= 0)
    success = FALSE;

  src_height = args[4].value.pdb_int;
  if (src_height <= 0)
    success = FALSE;

  dest_width = args[5].value.pdb_int;
  if (dest_width <= 0 || dest_width > 512)
    success = FALSE;

  dest_height = args[6].value.pdb_int;
  if (dest_height <= 0 || dest_height > 512)
    success = FALSE;

  if (success)
    {
      success = ((src_x + src_width)  <= gimp_item_width  (GIMP_ITEM (drawable)) &&
                 (src_y + src_height) <= gimp_item_height (GIMP_ITEM (drawable)));

      if (success)
        {
          GimpImage *gimage = gimp_item_get_image (GIMP_ITEM (drawable));
          TempBuf   *buf;

          if (gimage->gimp->config->layer_previews)
            buf = gimp_drawable_get_sub_preview (drawable,
                                                 src_x, src_y,
                                                 src_width, src_height,
                                                 dest_width, dest_height);
          else
            buf = gimp_viewable_get_dummy_preview (GIMP_VIEWABLE (drawable),
                                                   dest_width, dest_height,
                                                   gimp_drawable_has_alpha (drawable) ?
                                                   4 : 3);

          if (buf)
            {
              num_bytes      = buf->height * buf->width * buf->bytes;
              thumbnail_data = g_memdup (temp_buf_data (buf), num_bytes);
              width          = buf->width;
              height         = buf->height;
              bpp            = buf->bytes;

              temp_buf_free (buf);
            }
          else
            {
              success = FALSE;
            }
        }
    }

  return_args = procedural_db_return_args (&drawable_sub_thumbnail_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = width;
      return_args[2].value.pdb_int = height;
      return_args[3].value.pdb_int = bpp;
      return_args[4].value.pdb_int = num_bytes;
      return_args[5].value.pdb_pointer = thumbnail_data;
    }

  return return_args;
}

static ProcArg drawable_sub_thumbnail_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "src-x",
    "The x coordinate of the area"
  },
  {
    GIMP_PDB_INT32,
    "src-y",
    "The y coordinate of the area"
  },
  {
    GIMP_PDB_INT32,
    "src-width",
    "The width of the area"
  },
  {
    GIMP_PDB_INT32,
    "src-height",
    "The height of the area"
  },
  {
    GIMP_PDB_INT32,
    "dest-width",
    "The thumbnail width"
  },
  {
    GIMP_PDB_INT32,
    "dest-height",
    "The thumbnail height"
  }
};

static ProcArg drawable_sub_thumbnail_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "width",
    "The previews width"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The previews height"
  },
  {
    GIMP_PDB_INT32,
    "bpp",
    "The previews bpp"
  },
  {
    GIMP_PDB_INT32,
    "thumbnail-data-count",
    "The number of bytes in thumbnail data"
  },
  {
    GIMP_PDB_INT8ARRAY,
    "thumbnail-data",
    "The thumbnail data"
  }
};

static ProcRecord drawable_sub_thumbnail_proc =
{
  "gimp-drawable-sub-thumbnail",
  "gimp-drawable-sub-thumbnail",
  "Get a thumbnail of a sub-area of a drawable drawable.",
  "This function gets data from which a thumbnail of a drawable preview can be created. Maximum x or y dimension is 512 pixels. The pixels are returned in RGB[A] or GRAY[A] format. The bpp return value gives the number of bytes in the image.",
  "Michael Natterer <mitch@gimp.org>",
  "Michael Natterer <mitch@gimp.org>",
  "2004",
  NULL,
  GIMP_INTERNAL,
  7,
  drawable_sub_thumbnail_inargs,
  5,
  drawable_sub_thumbnail_outargs,
  { { drawable_sub_thumbnail_invoker } }
};

static Argument *
drawable_foreground_extract_invoker (Gimp         *gimp,
                                     GimpContext  *context,
                                     GimpProgress *progress,
                                     Argument     *args)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gint32 mode;
  GimpDrawable *mask;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  mode = args[1].value.pdb_int;
  if (mode != GIMP_FOREGROUND_EXTRACT_SIOX)
    success = FALSE;

  mask = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[2].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (mask) && ! gimp_item_is_removed (GIMP_ITEM (mask))))
    success = FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success)
        gimp_drawable_foreground_extract (drawable, mode, mask, progress);
    }

  return procedural_db_return_args (&drawable_foreground_extract_proc, success);
}

static ProcArg drawable_foreground_extract_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The drawable"
  },
  {
    GIMP_PDB_INT32,
    "mode",
    "The algorithm to use: GIMP_FOREGROUND_EXTRACT_SIOX (0)"
  },
  {
    GIMP_PDB_DRAWABLE,
    "mask",
    "Tri-Map"
  }
};

static ProcRecord drawable_foreground_extract_proc =
{
  "gimp-drawable-foreground-extract",
  "gimp-drawable-foreground-extract",
  "Extract the foreground of a drawable using a given trimap.",
  "Image Segmentation by Uniform Color Clustering, see http://www.inf.fu-berlin.de/inst/pubs/tr-b-05-07.pdf",
  "Gerald Friedland <fland@inf.fu-berlin.de>, Kristian Jantz <jantz@inf.fu-berlin.de>, Sven Neumann <sven@gimp.org>",
  "Gerald Friedland",
  "2005",
  NULL,
  GIMP_INTERNAL,
  3,
  drawable_foreground_extract_inargs,
  0,
  NULL,
  { { drawable_foreground_extract_invoker } }
};
